# Organization-related stuff.
#
#   Copyright (C) 2003 Daniel Burrows <dburrows@debian.org>
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import sort
import treemodel

# some default organizations.  Organizations are a tuple
# (root-group-generator, sort-method, name)

CANNED_ORGANIZATIONS = {
    'ArtistAlbum' :
    (lambda model,gui,extracolumns:
         treemodel.TagGroup(None, None, None, model, gui, extracolumns, "Artist",
                       lambda iter,parent,label:
                       treemodel.TagGroup(iter,
                                          parent,
                                          label,
                                          model,
                                          gui,
                                          extracolumns,
                                          "Album",
                                          lambda iter, parent, label:
                                            treemodel.NullGroup(iter,
                                                                parent,
                                                                label,
                                                                model,
                                                                gui,
                                                                extracolumns))),
     sort.make_basic_sort(2),
     'By Artist and Album'),
    'GenreArtistAlbum' :
    (lambda model,gui,extracolumns:
         treemodel.TagGroup(None, None, None,
                            model, gui, extracolumns, "Genre",
                            lambda iter,parent,label:
                            treemodel.TagGroup(iter, parent, label,
                                               model, gui, extracolumns,
                                               "Artist",
                                               lambda iter,parent,label:
                                               treemodel.TagGroup(iter, parent, label, model, gui, extracolumns, "Album",
                                                                  lambda iter, parent, label:treemodel.NullGroup(iter, parent, label, model, gui, extracolumns)))),
     sort.make_basic_sort(3),
     'By Genre, Artist and Album'),
    'Artist' :
    (lambda model,gui,extracolumns:
         treemodel.TagGroup(None, None, None, model, gui, extracolumns, "Artist",
                            lambda iter,parent,label:
                                treemodel.NullGroup(iter, parent, label,
                                                    model, gui, extracolumns)),
     sort.sort_by(sort.column(treemodel.COLUMN_LABEL)),
     'By Artist'),
    'Album' :
    (lambda model,gui,extracolumns:
         treemodel.TagGroup(None, None, None, model, gui, extracolumns, "Album",
                            lambda iter,parent,label:
                                treemodel.NullGroup(iter, parent, label,
                                                    model, gui, extracolumns)),
     sort.make_basic_sort(1),
     'By Album'),
    'Title' :
    (lambda model,gui,extracolumns:
         treemodel.NullGroup(None, None, None, model, gui, extracolumns),
     sort.sort_by(sort.column(treemodel.COLUMN_LABEL)),
     'By Title')
}
