/*
 * VisualAreaMapTool.java
 *
 * Created on May 14, 2010, 11:28:50 AM
 *
 * A simple tool for interactive display of an AreaMap (as defined by the libncarg module "Areas").
 *
 */

package edu.ucar.vets;

import java.io.IOException;

/**
 *
 * @author brownrig
 */
public class VisualAreaMapTool extends javax.swing.JFrame implements SelectListener {

    /** Creates new form VisualAreaMapTool */
    public VisualAreaMapTool(String areaMapFile) {
        initComponents();

        try {
            areaMap = AreaMap.readAreaMap(areaMapFile);
        } catch (IOException ex) {
            System.err.println("Error reading area map:");
            System.err.println("  " + ex.toString());
        }

        areaMapPanel.setAreaMap(areaMap);
        areaMapPanel.addSelectListener(this);
    }

    public void selectNode(int nodeId) {
        currentNodeId = nodeId;
        String str = (nodeId > 0) ? Integer.toString(nodeId) : "";
        nodeTextField.setText(str);
        updateSelectedNode();
    }

    private void updateSelectedNode() {
        areaMapPanel.setHighlightEdgeId(currentNodeId);

        if (currentNodeId > 0) {
            AreaMap.Node n = areaMap.getNode(currentNodeId);
            String str = "ID=" + currentNodeId + "   Nd=" + n.nextNode + "  Pd=" + n.prevNode +
                    "   Nc=" + n.nextCoord + "  Pc=" + n.prevCoord + "   L=" + n.leftId +
                    "  R=" + n.rightId + "  G=" + n.groupId + "   F=" + n.flag +
                    "   XY=" + n.x + "," + n.y;
            nodeInfoLabel.setText(str);
        }
        else
            nodeInfoLabel.setText("");
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        nodeTextField = new javax.swing.JTextField();
        areaMapPanel = new edu.ucar.vets.AreaMapRenderPanel();
        nextNodeButton = new javax.swing.JButton();
        prevNodeButton = new javax.swing.JButton();
        nodeInfoLabel = new javax.swing.JLabel();
        menuBar = new javax.swing.JMenuBar();
        fileMenu = new javax.swing.JMenu();
        openMenuItem = new javax.swing.JMenuItem();
        exitMenuItem = new javax.swing.JMenuItem();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("VisualAreaMapTool");

        jLabel1.setText("FInd Node ID:");

        nodeTextField.setFocusCycleRoot(true);
        nodeTextField.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                nodeTextFieldActionPerformed(evt);
            }
        });

        areaMapPanel.setBackground(javax.swing.UIManager.getDefaults().getColor("Button.highlight"));
        areaMapPanel.setBorder(javax.swing.BorderFactory.createCompoundBorder(javax.swing.BorderFactory.createBevelBorder(javax.swing.border.BevelBorder.LOWERED), javax.swing.BorderFactory.createBevelBorder(javax.swing.border.BevelBorder.LOWERED)));

        javax.swing.GroupLayout areaMapPanelLayout = new javax.swing.GroupLayout(areaMapPanel);
        areaMapPanel.setLayout(areaMapPanelLayout);
        areaMapPanelLayout.setHorizontalGroup(
            areaMapPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 508, Short.MAX_VALUE)
        );
        areaMapPanelLayout.setVerticalGroup(
            areaMapPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 377, Short.MAX_VALUE)
        );

        nextNodeButton.setText("Next");
        nextNodeButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                nextNodeAction(evt);
            }
        });

        prevNodeButton.setText("Prev");
        prevNodeButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                prevNodeAction(evt);
            }
        });

        nodeInfoLabel.setForeground(java.awt.Color.blue);

        fileMenu.setText("File");

        openMenuItem.setText("Open");
        fileMenu.add(openMenuItem);

        exitMenuItem.setText("Exit");
        exitMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                exitMenuItemActionPerformed(evt);
            }
        });
        fileMenu.add(exitMenuItem);

        menuBar.add(fileMenu);

        setJMenuBar(menuBar);

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(areaMapPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel1)
                .addGap(1, 1, 1)
                .addComponent(nodeTextField, javax.swing.GroupLayout.PREFERRED_SIZE, 87, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(nextNodeButton)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(prevNodeButton)
                .addContainerGap(241, Short.MAX_VALUE))
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(nodeInfoLabel, javax.swing.GroupLayout.DEFAULT_SIZE, 492, Short.MAX_VALUE)
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(areaMapPanel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel1)
                    .addComponent(nodeTextField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(nextNodeButton)
                    .addComponent(prevNodeButton))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(nodeInfoLabel, javax.swing.GroupLayout.PREFERRED_SIZE, 21, javax.swing.GroupLayout.PREFERRED_SIZE))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void exitMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_exitMenuItemActionPerformed
        System.exit(0);
    }//GEN-LAST:event_exitMenuItemActionPerformed

    private void nodeTextFieldActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_nodeTextFieldActionPerformed
        String text = nodeTextField.getText();
        if (text.equals("")) {
            currentNodeId = -1;
        } else {
            try {
                currentNodeId = Integer.parseInt(text);
                areaMapPanel.setHighlightEdgeId(currentNodeId);
            } catch (Exception ex) {
                System.err.println("Parse error...");
                currentNodeId = -1;
            }
        }
        updateSelectedNode();
    }//GEN-LAST:event_nodeTextFieldActionPerformed

    private void nextNodeAction(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_nextNodeAction
        if (currentNodeId > 0) {
            AreaMap.Node n = areaMap.getNode(currentNodeId);
            currentNodeId = n.nextNode;
            updateSelectedNode();
            nodeTextField.setText(Integer.toString(currentNodeId));
        }
    }//GEN-LAST:event_nextNodeAction

    private void prevNodeAction(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_prevNodeAction
        if (currentNodeId > 0) {
            AreaMap.Node n = areaMap.getNode(currentNodeId);
            currentNodeId = n.prevNode;
            updateSelectedNode();
            nodeTextField.setText(Integer.toString(currentNodeId));
        }
    }//GEN-LAST:event_prevNodeAction

    /**
    * @param args the command line arguments
    */
    public static void main(String args[]) {
        final String areaMapFile = args[0];
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new VisualAreaMapTool(areaMapFile).setVisible(true);
            }
        });
    }

    private AreaMap areaMap;
    private int currentNodeId = -1;

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private edu.ucar.vets.AreaMapRenderPanel areaMapPanel;
    private javax.swing.JMenuItem exitMenuItem;
    private javax.swing.JMenu fileMenu;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JMenuBar menuBar;
    private javax.swing.JButton nextNodeButton;
    private javax.swing.JLabel nodeInfoLabel;
    private javax.swing.JTextField nodeTextField;
    private javax.swing.JMenuItem openMenuItem;
    private javax.swing.JButton prevNodeButton;
    // End of variables declaration//GEN-END:variables

}
