import test from 'ava';
import camelCase from '.';

test('camelCase', t => {
	t.is(camelCase('foo'), 'foo');
	t.is(camelCase('foo-bar'), 'fooBar');
	t.is(camelCase('foo-bar-baz'), 'fooBarBaz');
	t.is(camelCase('foo--bar'), 'fooBar');
	t.is(camelCase('--foo-bar'), 'fooBar');
	t.is(camelCase('--foo--bar'), 'fooBar');
	t.is(camelCase('FOO-BAR'), 'fooBar');
	t.is(camelCase('FOÈ-BAR'), 'foèBar');
	t.is(camelCase('-foo-bar-'), 'fooBar');
	t.is(camelCase('--foo--bar--'), 'fooBar');
	t.is(camelCase('foo.bar'), 'fooBar');
	t.is(camelCase('foo..bar'), 'fooBar');
	t.is(camelCase('..foo..bar..'), 'fooBar');
	t.is(camelCase('foo_bar'), 'fooBar');
	t.is(camelCase('__foo__bar__'), 'fooBar');
	t.is(camelCase('__foo__bar__'), 'fooBar');
	t.is(camelCase('foo bar'), 'fooBar');
	t.is(camelCase('  foo  bar  '), 'fooBar');
	t.is(camelCase('-'), '-');
	t.is(camelCase(' - '), '-');
	t.is(camelCase('fooBar'), 'fooBar');
	t.is(camelCase('fooBar-baz'), 'fooBarBaz');
	t.is(camelCase('foìBar-baz'), 'foìBarBaz');
	t.is(camelCase('fooBarBaz-bazzy'), 'fooBarBazBazzy');
	t.is(camelCase('FBBazzy'), 'fbBazzy');
	t.is(camelCase('F'), 'f');
	t.is(camelCase('FooBar'), 'fooBar');
	t.is(camelCase('Foo'), 'foo');
	t.is(camelCase('FOO'), 'foo');
	t.is(camelCase(['foo', 'bar']), 'fooBar');
	t.is(camelCase(['foo', '-bar']), 'fooBar');
	t.is(camelCase(['foo', '-bar', 'baz']), 'fooBarBaz');
	t.is(camelCase(['', '']), '');
	t.is(camelCase('--'), '');
	t.is(camelCase(''), '');
	t.is(camelCase('--__--_--_'), '');
	t.is(camelCase(['---_', '--', '', '-_- ']), '');
	t.is(camelCase('foo bar?'), 'fooBar?');
	t.is(camelCase('foo bar!'), 'fooBar!');
	t.is(camelCase('foo bar$'), 'fooBar$');
	t.is(camelCase('foo-bar#'), 'fooBar#');
	t.is(camelCase('XMLHttpRequest'), 'xmlHttpRequest');
	t.is(camelCase('AjaxXMLHttpRequest'), 'ajaxXmlHttpRequest');
	t.is(camelCase('Ajax-XMLHttpRequest'), 'ajaxXmlHttpRequest');
	t.is(camelCase([]), '');
	t.is(camelCase('mGridCol6@md'), 'mGridCol6@md');
	t.is(camelCase('A::a'), 'a::a');
	t.is(camelCase('Hello1World'), 'hello1World');
	t.is(camelCase('Hello11World'), 'hello11World');
	t.is(camelCase('hello1world'), 'hello1World');
	t.is(camelCase('Hello1World11foo'), 'hello1World11Foo');
	t.is(camelCase('Hello1'), 'hello1');
	t.is(camelCase('hello1'), 'hello1');
	t.is(camelCase('1Hello'), '1Hello');
	t.is(camelCase('1hello'), '1Hello');
});

test('camelCase with pascalCase option', t => {
	t.is(camelCase('foo', {pascalCase: true}), 'Foo');
	t.is(camelCase('foo-bar', {pascalCase: true}), 'FooBar');
	t.is(camelCase('foo-bar-baz', {pascalCase: true}), 'FooBarBaz');
	t.is(camelCase('foo--bar', {pascalCase: true}), 'FooBar');
	t.is(camelCase('--foo-bar', {pascalCase: true}), 'FooBar');
	t.is(camelCase('--foo--bar', {pascalCase: true}), 'FooBar');
	t.is(camelCase('FOO-BAR', {pascalCase: true}), 'FooBar');
	t.is(camelCase('FOÈ-BAR', {pascalCase: true}), 'FoèBar');
	t.is(camelCase('-foo-bar-', {pascalCase: true}), 'FooBar');
	t.is(camelCase('--foo--bar--', {pascalCase: true}), 'FooBar');
	t.is(camelCase('foo.bar', {pascalCase: true}), 'FooBar');
	t.is(camelCase('foo..bar', {pascalCase: true}), 'FooBar');
	t.is(camelCase('..foo..bar..', {pascalCase: true}), 'FooBar');
	t.is(camelCase('foo_bar', {pascalCase: true}), 'FooBar');
	t.is(camelCase('__foo__bar__', {pascalCase: true}), 'FooBar');
	t.is(camelCase('__foo__bar__', {pascalCase: true}), 'FooBar');
	t.is(camelCase('foo bar', {pascalCase: true}), 'FooBar');
	t.is(camelCase('  foo  bar  ', {pascalCase: true}), 'FooBar');
	t.is(camelCase('-', {pascalCase: true}), '-');
	t.is(camelCase(' - ', {pascalCase: true}), '-');
	t.is(camelCase('fooBar', {pascalCase: true}), 'FooBar');
	t.is(camelCase('fooBar-baz', {pascalCase: true}), 'FooBarBaz');
	t.is(camelCase('foìBar-baz', {pascalCase: true}), 'FoìBarBaz');
	t.is(camelCase('fooBarBaz-bazzy', {pascalCase: true}), 'FooBarBazBazzy');
	t.is(camelCase('FBBazzy', {pascalCase: true}), 'FbBazzy');
	t.is(camelCase('F', {pascalCase: true}), 'F');
	t.is(camelCase('FooBar', {pascalCase: true}), 'FooBar');
	t.is(camelCase('Foo', {pascalCase: true}), 'Foo');
	t.is(camelCase('FOO', {pascalCase: true}), 'Foo');
	t.is(camelCase(['foo', 'bar'], {pascalCase: true}), 'FooBar');
	t.is(camelCase(['foo', '-bar'], {pascalCase: true}), 'FooBar');
	t.is(camelCase(['foo', '-bar', 'baz'], {pascalCase: true}), 'FooBarBaz');
	t.is(camelCase(['', ''], {pascalCase: true}), '');
	t.is(camelCase('--', {pascalCase: true}), '');
	t.is(camelCase('', {pascalCase: true}), '');
	t.is(camelCase('--__--_--_', {pascalCase: true}), '');
	t.is(camelCase(['---_', '--', '', '-_- '], {pascalCase: true}), '');
	t.is(camelCase('foo bar?', {pascalCase: true}), 'FooBar?');
	t.is(camelCase('foo bar!', {pascalCase: true}), 'FooBar!');
	t.is(camelCase('foo bar$', {pascalCase: true}), 'FooBar$');
	t.is(camelCase('foo-bar#', {pascalCase: true}), 'FooBar#');
	t.is(camelCase('XMLHttpRequest', {pascalCase: true}), 'XmlHttpRequest');
	t.is(camelCase('AjaxXMLHttpRequest', {pascalCase: true}), 'AjaxXmlHttpRequest');
	t.is(camelCase('Ajax-XMLHttpRequest', {pascalCase: true}), 'AjaxXmlHttpRequest');
	t.is(camelCase([], {pascalCase: true}), '');
	t.is(camelCase('mGridCol6@md', {pascalCase: true}), 'MGridCol6@md');
	t.is(camelCase('A::a', {pascalCase: true}), 'A::a');
	t.is(camelCase('Hello1World', {pascalCase: true}), 'Hello1World');
	t.is(camelCase('Hello11World', {pascalCase: true}), 'Hello11World');
	t.is(camelCase('hello1world', {pascalCase: true}), 'Hello1World');
	t.is(camelCase('hello1World', {pascalCase: true}), 'Hello1World');
	t.is(camelCase('hello1', {pascalCase: true}), 'Hello1');
	t.is(camelCase('Hello1', {pascalCase: true}), 'Hello1');
	t.is(camelCase('1hello', {pascalCase: true}), '1Hello');
	t.is(camelCase('1Hello', {pascalCase: true}), '1Hello');
});

test('invalid input', t => {
	t.throws(() => {
		camelCase(1);
	}, /Expected the input to be/);
});
