'use strict'

const path    = require('path')
const json    = require('rollup-plugin-json')
const resolve = require('rollup-plugin-node-resolve')
const common  = require('rollup-plugin-commonjs')
const buble   = require('rollup-plugin-buble')
const ignore  = require('./rollup-plugin-ignore')

const BUNDLE  = process.env.BUNDLE === 'true'

let fileDest  = 'mocha.js'
const plugins = [
  json(),
  ignore(['fs', 'glob', 'path', 'supports-color']),
  resolve({
    customResolveOptions: {
      moduleDirectory: ['/usr/share/nodejs'],
      preferBuiltins: false
    }
  }),
  common(),
  buble()
]
module.exports = {
  input: 'browser-entry.js',
  output: {
    file: path.resolve(__dirname, `../${fileDest}`),
    format: 'umd',
    name: 'mocha'
  },
  plugins
}
