// Generated by LiveScript 1.6.0
(function(){
  var ref$, id, isType, replicate, VERSION, eq, deepEq, ok;
  ref$ = require('../..'), id = ref$.id, isType = ref$.isType, replicate = ref$.replicate, VERSION = ref$.VERSION;
  ref$ = require('assert'), eq = ref$.strictEqual, deepEq = ref$.deepEqual, ok = ref$.ok;
  describe('library', function(){
    return it('version', function(){
      return eq(VERSION, require('../../package.json').version);
    });
  });
  describe('id', function(){
    it('number', function(){
      return eq(5, id(5));
    });
    return it('object is the same', function(){
      var obj;
      obj = {};
      return eq(obj, id(obj));
    });
  });
  describe('is-type', function(){
    it('literals', function(){
      ok(isType('Undefined', void 8));
      ok(isType('Boolean', true));
      ok(isType('Number', 1));
      ok(isType('Number', 1.2));
      ok(isType('String', 'asdfa'));
      ok(isType('Object', {}));
      ok(isType('Array', []));
      return ok(!isType('Boolean', 1));
    });
    it('constructors', function(){
      return ok(isType('Date', new Date));
    });
    it('classes', function(){
      var A;
      A = (function(){
        A.displayName = 'A';
        var prototype = A.prototype, constructor = A;
        function A(){}
        return A;
      }());
      return ok(isType('Object', new A));
    });
    return it('curried', function(){
      var f;
      f = isType('Boolean');
      return ok(f(true));
    });
  });
  describe('replicate', function(){
    it('zero as input', function(){
      deepEq([], replicate(0, 0));
      return deepEq([], replicate(0, 'a'));
    });
    it('number as input', function(){
      return deepEq([3, 3, 3, 3], replicate(4, 3));
    });
    it('string as input', function(){
      return deepEq(['a', 'a', 'a', 'a'], replicate(4, 'a'));
    });
    return it('curried', function(){
      var f;
      f = replicate(4);
      return deepEq([3, 3, 3, 3], f(3));
    });
  });
}).call(this);
