#!/bin/sh

echo "["
echo "# --- Generated by ${0##*/} ---"
LAST_MODULE=""
for MODULE in QtAndroidExtras QtCore QtGui QtNetwork QtPositioning QtPrintSupport QtSensors QtSerialPort QtTest QtWidgets
do
	echo "\n    # ${MODULE}"
	for I in $(find "${MODULE}" -type f -name "Q*")
	do
		INCLUDE="${I##*/}"
		INCLUDE_LC=$(echo "$INCLUDE.h" | awk '{print tolower($0)}')
		INCLUDE_DIR="${I%/*}"
		#echo "$INCLUDE_DIR $INCLUDE $INCLUDE_LC";
		if [ "${MODULE}" = "QtTest" ]
		then
			# Use only <QtTest> for module QtTest
			if [ "${INCLUDE}" = "QtTest" ]
			then
				for J in $(find "${MODULE}" -type f -name "q*.h")
				do
					INCLUDE="${J##*/}"
					echo "    { include: [ \"<${INCLUDE}>\", \"private\", \"<QtTest>\", \"public\" ] },"
				done
			else
				echo "    { include: [ \"<${INCLUDE}>\", \"private\", \"<QtTest>\", \"public\" ] },"
			fi
		elif [ -f "$INCLUDE_DIR/$INCLUDE_LC" -a $(grep "#include \"$INCLUDE_LC" "$I" | wc -l) -eq 1 ]
		then
			# Use public <QFoo> include for <qfoo.h> include
			grep "#include \"$INCLUDE_LC" "$I" | sed -e "s/.*\"\(.*\)\"/    { include: [ \"<\1>\", \"private\", \"<${INCLUDE}>\", \"public\" ] },/"
		elif [ "${INCLUDE#Qt}" = "${INCLUDE}" ]
		then
			# Use public <QFoo> include for QFoo symbol
			if [ $(grep "#include \"q" "$I" | wc -l) -eq 1 ]
			then
				echo "    { symbol: [ \"${INCLUDE}\", \"private\", \"<${INCLUDE}>\", \"public\" ] },"
			fi
		elif [ -f "$INCLUDE_DIR/q${INCLUDE_LC#qt}" -a $(grep "#include \"q${INCLUDE_LC#qt}" "$I" | wc -l) -eq 1 ]
		then
			# Use public QtFoo include for private qfoo.h include
			grep "#include \"q${INCLUDE_LC#qt}" "$I" | sed -e "s/.*\"\(.*\)\"/    { include: [ \"<\1>\", \"private\", \"<${INCLUDE}>\", \"public\" ] },/"
		fi
	done | sort
done # module

cat << END_EXTRA

# --- Manual additions ---

    # convenience
    { include: [ "<qbasicatomic.h>", "public", "<QAtomicInteger>", "public" ] },
    { include: [ "<QFlag>", "public", "<QFlags>", "public" ] },
    { include: [ "<QNoDebug>", "public", "<QDebug>", "public" ] },
    { include: [ "<QStaticByteArrayData>", "public", "<QByteArray>", "public" ] },
    { include: [ "<QStaticStringData>", "public", "<QString>", "public" ] },
    { include: [ "<QVariantComparisonHelper>", "public", "<QVariant>", "public" ] },
    # http://doc.qt.io/qt-5/qt.html
    { include: [ "<qnamespace.h>", "private", "<Qt>", "public" ] },
    # http://doc.qt.io/qt-5/qtglobal.html
    { include: [ "<QtMessageHandler>", "public", "<QtGlobal>", "public" ] },
    { include: [ "<QtMsgHandler>", "public", "<QtGlobal>", "public" ] },
    { include: [ "<qcompilerdetection.h>", "private", "<QtGlobal>", "public" ] },
    { include: [ "<qprocessordetection.h>", "private", "<QtGlobal>", "public" ] },
    { include: [ "<qsystemdetection.h>", "private", "<QtGlobal>", "public" ] },
    { include: [ "<qlogging.h>", "private", "<QtGlobal>", "public" ] },
    # http://doc.qt.io/qt-5/qevent.html
    { include: [ "<qevent.h>", "private", "<QEvent>", "public" ] },
    { include: [ "<qcoreevent.h>", "private", "<QEvent>", "public" ] },
    # http://doc.qt.io/qt-5/qmetaobject.html
    { include: [ "<qmetaobject.h>", "private", "<QMetaObject>", "public" ] },
    # http://doc.qt.io/qt-5/qobject.html
    { include: [ "<qobjectdefs.h>", "private", "<QObject>", "public" ] },
    # http://doc.qt.io/qt-5/qstring.html
    { include: [ "<qstringliteral.h>", "private", "<QString>", "public" ] },
    # http://doc.qt.io/qt-5/qtconcurrent.html
    { include: [ "<qtconcurrentfilter.h>", "private", "<QtConcurrent>", "public" ] },
    { include: [ "<qtconcurrentmap.h>", "private", "<QtConcurrent>", "public" ] },
    { include: [ "<qtconcurrentrun.h>", "private", "<QtConcurrent>", "public" ] },

END_EXTRA

echo "]"
