# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 041-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53802);
 script_version ("$");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 041-1 (joe)";
 script_name(name);

 desc = "The remote host is missing an update to joe
announced via advisory DSA 041-1.

Christer berg of Wkit Security AB found a problem in joe (Joe's
Own Editor). joe will look for a configuration file in three
locations: the current directory, the users homedirectory ($HOME)
and in /etc/joe. Since the configuration file can define commands
joe will run (for example to check spelling) reading it from
the current directory can be dangerous: an attacker can leave
a .joerc file in a writable directory, which would be read when
a unsuspecting user starts joe in that directory.

This has been fixed in version 2.8-15.3 and we recommend that
you upgrade your joe package immediately.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20041-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 041-1 (joe)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"joe", ver:"2.8-15.3", rls:"DEB2.2")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
