# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1561-1 (ldm)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(60866);
 script_cve_id("CVE-2008-1293");
 script_version ("$");
 script_tag(name:"cvss_base", value:"4.8");
 script_tag(name:"risk_factor", value:"Medium");
 name = "Debian Security Advisory DSA 1561-1 (ldm)";
 script_name(name);

 desc = "The remote host is missing an update to ldm
announced via advisory DSA 1561-1.

Christian Herzog discovered that within the Linux Terminal Server Project,
it was possible to connect to X on any LTSP client from any host on the
network, making client windows and keystrokes visible to that host.

NOTE: most ldm installs are likely to be in a chroot environment exported
over NFS, and will not be upgraded merely by upgrading the server itself.
For example, on the i386 architecture, to upgrade ldm will likely require:

chroot /opt/ltsp/i386 apt-get update
chroot /opt/ltsp/i386 apt-get dist-upgrade


For the stable distribution (etch), this problem has been fixed in
version 0.99debian11+etch1.

For the unstable distribution (sid), this problem has been fixed in
version 2:0.1~bzr20080308-1.

We recommend that you upgrade your ldm package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201561-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1561-1 (ldm)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"ltsp-server-standalone", ver:"0.99debian11+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ltsp-server", ver:"0.99debian11+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ldm", ver:"0.99debian11+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ltsp-client", ver:"0.99debian11+etch1", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
