# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1772-1 (udev)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63842);
 script_cve_id("CVE-2009-1185", "CVE-2009-1186");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.2");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 1772-1 (udev)";
 script_name(name);

 desc = "The remote host is missing an update to udev
announced via advisory DSA 1772-1.

Sebastian Kramer discovered two vulnerabilities in udev, the /dev and
hotplug management daemon.

CVE-2009-1185

udev does not check the origin of NETLINK messages, allowing local
users to gain root privileges.

CVE-2009-1186

udev suffers from a buffer overflow condition in path encoding,
potentially allowing arbitrary code execution.

For the old stable distribution (etch), these problems have been fixed in
version 0.105-4etch1.

For the stable distribution (lenny), these problems have been fixed in
version 0.125-7+lenny1.

For the unstable distribution (sid), these problems will be fixed soon.

We recommend that you upgrade your udev package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201772-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1772-1 (udev)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"udev", ver:"0.105-4etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libvolume-id-dev", ver:"0.105-4etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libvolume-id0", ver:"0.105-4etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libvolume-id0", ver:"0.125-7+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"udev", ver:"0.125-7+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libvolume-id-dev", ver:"0.125-7+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
