# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 915-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(55945);
 script_cve_id("CVE-2005-2629");
 script_bugtraq_id(15381);
 script_version ("$");
 script_tag(name:"cvss_base", value:"5.1");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 915-1 (helix-player)";
 script_name(name);

 desc = "The remote host is missing an update to helix-player
announced via advisory DSA 915-1.

An integer overflow has been discovered in helix-player, the helix
audio and video player.  This flaw could allow a remote attacker to
run arbitrary code on a victims computer by supplying a specially
crafted network resource.

This vulnerability is fixed by version 1.0.6-1 in unstable.
Helix-player is not currently in the testing distribution.

The old stable distribution (woody) does not contain a helix-player
package.

For the stable distribution (sarge) these problems have been fixed in
version 1.0.4-1sarge2.

For the unstable distribution (sid) these problems have been fixed in
version 1.0.6-1.

We recommend that you upgrade your helix-player package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20915-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 915-1 (helix-player)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"helix-player", ver:"1.0.4-1sarge2", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
