#
#VID 9fae0f1f-df82-11d9-b875-0001020eed82
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53075);
 script_cve_id("CVE-2005-1267", "CVE-2005-1278", "CVE-2005-1279", "CVE-2005-1280");
 script_version ("$");
 script_tag(name:"cvss_base", value:"5.0");
 script_tag(name:"risk_factor", value:"Medium");
 name = "FreeBSD Ports: tcpdump";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: tcpdump

CVE-2005-1278
The isis_print function, as called by isoclns_print, in tcpdump 3.9.1
and earlier allows remote attackers to cause a denial of service
(infinite loop) via a zero length, as demonstrated using a GRE packet.

CVE-2005-1279
tcpdump 3.8.3 and earlier allows remote attackers to cause a denial of
service (infinite loop) via a crafted (1) BGP packet, which is not
properly handled by RT_ROUTING_INFO, or (2) LDP packet, which is not
properly handled by the ldp_print function.

CVE-2005-1280
The rsvp_print function in tcpdump 3.9.1 and earlier allows remote
attackers to cause a denial of service (infinite loop) via a crafted
RSVP packet of length 4.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://marc.theaimsgroup.com/?l=bugtraq&m=111454406222040
http://marc.theaimsgroup.com/?l=bugtraq&m=111454461300644
http://marc.theaimsgroup.com/?l=bugtraq&m=111928309502304
http://www.vuxml.org/freebsd/9fae0f1f-df82-11d9-b875-0001020eed82.html

Risk factor : Medium";

 script_description(desc);

 summary = "FreeBSD Ports: tcpdump";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"tcpdump");
if(!isnull(bver) && revcomp(a:bver, b:"3.8.3_2")<0) {
    security_note(0, data:"Package tcpdump version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
