###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_adobe_fms_detect.nasl 2107 2009-05-04 15:56:14Z may $
#
# Adobe Flash Media Server Detection
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800559);
  script_version("Revision: 1.0");
  script_tag(name:"risk_factor", value:"None");
  script_name("Adobe Flash Media Server Detection");
  desc = "

  Overview: This script detects the version of Adobe Flash Media Server and
  sets the result in the KB.

  Risk factor: None";

  script_description(desc);
  script_summary("Check for the Version of Adobe Flash Media Server");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 1111);
  exit(0);
}


include("http_func.inc");

fmsPort = get_http_port(default:1111);
if(!fmsPort){
  fmsPort = 1111;
}

if(!get_port_state(fmsPort)){
  exit(0);
}

sndReq = string("GET / HTTP/1.1 \r\n\r\n");
rcvRes = http_send_recv(port:fmsPort, data:sndReq);
if("FlashCom" >< rcvRes)
{
  fmsVer = eregmatch(pattern:"FlashCom/([0-9.]+)", string:rcvRes);
  if(fmsVer[1] != NULL)
  {
    set_kb_item(name:"www/" + fmsPort + "/Adobe/FMS", value:fmsVer[1]);
    security_note(data:"FlashCom version " + fmsVer[1] + " was detected on the host");
  }
}
