###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for openafs MDKA-2007:124 (openafs)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830152);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "MDKA", value: "2007:124");
  script_name( "Mandriva Update for openafs MDKA-2007:124 (openafs)");
  desc = "

  Vulnerability Insight:

  This update addresses the following bugs in the openafs package:
  
  The openafs kernel module does not work on the x86_64 platform,
  triggering a kernel oops as soon as it is loaded.
  
  The openafs package was compiled with wrong gcc 4.2 compiler
  optimisations which prevented it from listing directory contents.
  
  This update fixes these issues.

  Affected Software/OS:
  openafs on Mandriva Linux 2008.0,
  Mandriva Linux 2008.0/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2007-11/msg00058.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of openafs");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2008.0")
{

  if(isrpmvuln(pkg:"dkms-libafs", rpm:"dkms-libafs~1.4.4~6mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libopenafs1", rpm:"libopenafs1~1.4.4~6mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"libopenafs1-devel", rpm:"libopenafs1-devel~1.4.4~6mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"openafs", rpm:"openafs~1.4.4~6mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"openafs-client", rpm:"openafs-client~1.4.4~6mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"openafs-doc", rpm:"openafs-doc~1.4.4~6mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"openafs-server", rpm:"openafs-server~1.4.4~6mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64openafs1", rpm:"lib64openafs1~1.4.4~6mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"lib64openafs1-devel", rpm:"lib64openafs1-devel~1.4.4~6mdv2008.0", rls:"MNDK_2008.0"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}