###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_wordpressmu_xss_vuln_apr09.nasl 1069 2009-04-23 15:31:09Z apr $
#
# WordPress MU Cross-Site Scripting Vulnerability - Apr09
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800376);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"4.3");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-1030");
  script_bugtraq_id(34075);
  script_name("WordPress MU Cross-Site Scripting Vulnerability - Apr09");
  desc = "

  Overview: The host is running WordPress MU and is prone to Cross-Site
  Scripting Vulnerability.

  Vulnerability Insight:
  The vulnerability is due to improper validation of user supplied input in
  'wp-includes/wpmu-functions.php' for choose_primary_blog function.

  Impact:
  Successful exploitation will let the attacker execute malicious crafted
  HTTP headers and conduct cross site scripting attacks to gain administrative
  privileges into the affected web application.

  Impact Level: Application

  Affected Software/OS:
  WordPress MU before 2.7 on all running platform.

  Fix: Update to Version 2.7
  http://mu.wordpress.org/download

  References:
  http://www.milw0rm.com/exploits/8196
  http://xforce.iss.net/xforce/xfdb/49184
  http://securitytracker.com/alerts/2009/Mar/1021838.html

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:N/I:P/A:N)
    CVSS Temporal Score : 3.4
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the Version of WordPress MU");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Web application abuses");
  script_dependencies("secpod_wordpress_detect_900182.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}

include("http_func.inc");
include("version_func.inc");

wpmuPort = get_http_port(default:80);
if(!wpmuPort){
  exit(0);
}

wpmuVer = get_kb_item("www/" + wpmuPort + "/WordPress-Mu");
wpmuVer = eregmatch(pattern:"^(.+) under (/.*)$", string:wpmuVer);
if(wpmuVer[1] != NULL)
{
  if(version_is_less(version:wpmuVer[1], test_version:"2.7")){
    security_warning(wpmuPort);
  }
}
