###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ms09-020.nasl 2776 2009-06-10 12:24:04Z jun $
#
# Microsoft IIS Security Bypass Vulnerability (970483)
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################


if(description)
{
  script_id(900567);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-1122", "CVE-2009-1535");
  script_bugtraq_id(34993, 35232);
  script_name("Microsoft IIS Security Bypass Vulnerability (970483)");
  desc = "

  Overview: This host has critical security update missing according to
  Microsoft Bulletin MS09-020.

  Vulnerability Insight:
  The flaw is caused due to,
  - WebDAV extension does not properly decode requested URLs, which could
    cause an incorrect configuration to be applied.
  - WebDav fails to verify credentials before accessing password-protected
    resources when handling HTTP GET or PROPFIND requests containig a Unicode
    encoded character with a 'Translate: f' header.

  Impact:
  Remote attackers could exploit this issue to bypass authentication and gain
  unauthorized read and upload access to protected folders.

  Impact Level: System

  Affected Software/OS:
  Microsoft Windows 2K  Service Pack 4 and prior
  Microsoft Windows XP  Service Pack 3 and prior
  Microsoft Windows 2k3 Service Pack 2 and prior

  Fix:
  Run Windows Update and update the listed hotfixes or download and
  update mentioned hotfixes in the advisory from the below link.
  http://www.microsoft.com/technet/security/bulletin/ms09-020.mspx

  References:
  http://secunia.com/advisories/35109
  http://support.microsoft.com/kb/970483
  http://www.microsoft.com/technet/security/bulletin/ms09-018.mspx

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 6.9
  Risk factor : High";

  script_description(desc);
  script_summary("Check for the vulnerable file version and Hotfix");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Windows : Microsoft Bulletins");
  script_dependencies("secpod_reg_enum.nasl", "secpod_ms_iis_detect.nasl");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("http_func.inc");
include("secpod_reg.inc");
include("version_func.inc");
include("secpod_smb_func.inc");


iisPort = get_http_port(default:80);
if(!iisPort){
  exit(0);
}

if(!get_kb_item("IIS/" + iisPort + "/Ver")){
  exit(0);
}

if(hotfix_check_sp(xp:4, win2k:5, win2003:3) <= 0){
  exit(0);
}

# Check for Hotfix 970483 (MS09-020).
if(hotfix_missing(name:"970483") == 0){
  exit(0);
}

httpPath = registry_get_sz(key:"SOFTWARE\Microsoft\COM3\Setup",
                           item:"Install Path");
if(!httpPath){
  exit(0);
}

share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:httpPath);
file =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1",
                     string:httpPath + "\inetsrv\httpext.dll");

httpVer = GetVer(file:file, share:share);
if(!httpVer){
  exit(0);
}

if(hotfix_check_sp(win2k:5) > 0)
{
  # Check for httpext.dll version < 5.0.2195.7290
  if(version_in_range(version:httpVer, test_version:"5.0",
                      test_version2:"5.0.2195.7289")){
    security_hole(0);
  }
}

else if(hotfix_check_sp(win2003:3) > 0)
{
  SP = get_kb_item("SMB/Win2003/ServicePack");
  if("Service Pack 2" >< SP)
  {
    # Check for httpext.dll version < 6.0.3790.4518
    if(version_in_range(version:httpVer, test_version:"6.0",
                       test_version2:"6.0.3790.4517")){
      security_hole(0);
    }
  }
  security_hole(0);
}

else if(hotfix_check_sp(xp:4) > 0)
{
  SP = get_kb_item("SMB/WinXP/ServicePack");
  if("Service Pack 2" >< SP)
  {
    # Check for httpext.dll version < 6.0.2600.3574
    if(version_in_range(version:httpVer, test_version:"6.0",
                       test_version2:"6.0.2600.3573")){
      security_hole(0);
    }
  }
  else if("Service Pack 3" >< SP)
  {
    # Check for httpext.dll version < 6.0.2600.5817
    if(version_in_range(version:httpVer, test_version:"6.0",
                       test_version2:"6.0.2600.5816")){
      security_hole(0);
    }
  }
  security_hole(0);
}
