/*
   ____    _ __           ____               __    ____
  / __/___(_) /  ___ ____/ __ \__ _____ ___ / /_  /  _/__  ____
 _\ \/ __/ / _ \/ -_) __/ /_/ / // / -_|_-</ __/ _/ // _ \/ __/
/___/\__/_/_.__/\__/_/  \___\_\_,_/\__/___/\__/ /___/_//_/\__(_)

Copyright on 2012 SciberQuest Inc.
*/
#include "pqSQImageGhosts.h"

#include <QCheckBox>
#include <QWidget>

#include <iostream>
using std::cerr;
using std::endl;

//-----------------------------------------------------------------------------
pqSQImageGhosts::pqSQImageGhosts(
      pqProxy* pxy,
      QWidget* p)
             :
  pqAutoGeneratedObjectPanel(pxy,p)
{
  #if defined pqSQImageGhostsDEBUG
  cerr << ":::::pqSQImageGhosts" << endl;
  #endif

  // the arrays to copy list box should be disabled if
  // copy point data is set.

  QCheckBox *copyPointData = this->findChild<QCheckBox*>("CopyAllArrays");
  QWidget *arraysToCopy = this->findChild<QWidget*>("ArraysToCopy");

  // initialize based on current state, set by PV SM.
  if (copyPointData->isChecked())
    {
    arraysToCopy->setEnabled(false);
    }

  connect(
      copyPointData,SIGNAL(clicked(bool)),
      arraysToCopy,SLOT(setDisabled(bool)));
}
