// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef AVTVARMETADATA_H
#define AVTVARMETADATA_H
#include <dbatts_exports.h>
#include <avtTypes.h>
#include <string>
#include <avtBaseVarMetaData.h>

#include <vector>

// ****************************************************************************
// Class: avtVarMetaData
//
// Purpose:
//    Contains metadata attributes associated with all mesh variables
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class DBATTS_API avtVarMetaData : public avtBaseVarMetaData
{
public:
    // These constructors are for objects of this class
    avtVarMetaData();
    avtVarMetaData(const avtVarMetaData &obj);
protected:
    // These constructors are for objects derived from this class
    avtVarMetaData(private_tmfs_t tmfs);
    avtVarMetaData(const avtVarMetaData &obj, private_tmfs_t tmfs);
public:
    virtual ~avtVarMetaData();

    virtual avtVarMetaData& operator = (const avtVarMetaData &obj);
    virtual bool operator == (const avtVarMetaData &obj) const;
    virtual bool operator != (const avtVarMetaData &obj) const;
private:
    void Init();
    void Copy(const avtVarMetaData &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;

    // User-defined methods
    avtVarMetaData(private_tmfs_t, std::string, std::string, avtCentering);
    avtVarMetaData(private_tmfs_t, std::string, std::string, avtCentering, double, double);
    void SetExtents(const double *);
    void UnsetExtents();
    void Print(ostream &, int = 0) const;

    // IDs that can be used to identify fields in case statements
    enum {
        ID_centering = avtBaseVarMetaData::ID__LAST,
        ID_hasUnits,
        ID_units,
        ID_hasDataExtents,
        ID_minDataExtents,
        ID_maxDataExtents,
        ID_matRestricted,
        ID__LAST
    };

public:
    avtCentering centering;
    bool         hasUnits;
    std::string  units;
    bool         hasDataExtents;
    double       minDataExtents;
    double       maxDataExtents;
    intVector    matRestricted;

private:
    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define AVTVARMETADATA_TMFS AVTBASEVARMETADATA_TMFS "ibsbddi*"

#endif
