#!/usr/bin/perl


use strict;
#use blib;
use File::Spec;
use Cwd;
use DBI;
use File::Copy;
use Test::DatabaseRow;
use Test::More tests => 50;
my $test_file = 'change3.xml';
use vars qw($host $np $session $svc $os $FH);

is(system("sudo ./scanpbnj -x t/$test_file > /dev/null"),0,"Scanpbnj input from $test_file");

#my $dbh = DBI->connect('dbi:SQLite:dbname=data.dbl');
my $dsn = "DBI:Pg:database=pbnjdb;host=localhost;port=5432";
my $dbh = DBI->connect( $dsn, "pbnjdb", "tmp" );

# set the default database handle
local $Test::DatabaseRow::dbh = $dbh;

# service 25
testService( {
        service         => 'ssh',
        port            => 22,
        proto           => 'tcp',
        version         => '4.2p1 Debian-7ubuntu3',
        state           => 'up',
        banner          => 'OpenSSH',
        updated_on      => 'Sat May 27 19:02:53 2006',
        machine_updated => '1148770973'
        });
testService( {
        service         => 'ipp',
        port            => 631,
        proto           => 'tcp',
        version         => '1.2',
        state           => 'up',
        banner          => 'CUPS',
        updated_on      => 'Sat May 27 19:02:53 2006',
        machine_updated => '1148770973'
        });
testService( {
        service         => 'smtp',
        port            => 25,
        proto           => 'tcp',
        version         => 'unknown version',
        state           => 'up',
        banner          => 'Postfix smtpd',
        updated_on      => 'Sat May 27 19:02:53 2006',
        machine_updated => '1148770973'
        });

testServiceChange( {
        service         => 'ssh',
        port            => 22,
        proto           => 'tcp',
        version         => '4.2p1 Debian-7ubuntu3',
        state           => 'down',
        banner          => 'OpenSSH',
        updated_on      => 'Sat May 27 19:03:24 2006',
        machine_updated => '1148771004'
        });
testServiceChange( {
        service         => 'ssh',
        port            => 22,
        proto           => 'tcp',
        version         => '4.2p1 Debian-7ubuntu3',
        state           => 'up',
        banner          => 'OpenSSH',
        updated_on      => 'Sat May 27 20:00:10 2006',
        machine_updated => '1148774410'
        });

testServiceChange( {
        service         => 'smtp',
        port            => 25,
        proto           => 'tcp',
        version         => 'unknown version',
        state           => 'down',
        banner          => 'Postfix smtpd',
        updated_on      => 'Sat May 27 20:00:10 2006',
        machine_updated => '1148774410'
        });
testServiceChange( {
        service         => 'ipp',
        port            => 631,
        proto           => 'tcp',
        version         => '1.2',
        state           => 'down',
        banner          => 'CUPS',
        updated_on      => 'Sat May 27 20:00:10 2006',
        machine_updated => '1148774410'
        });


#is(system("rm data.dbl"),0,"Removing Database");




sub testService{
   my ($href) = @_;

   die "testService: port not defined"      unless defined $href->{port};
   die "testService: service not defined" unless defined $href->{service};
   die "testService: version not defined"    unless defined $href->{version};
   die "testService: proto not defined"  unless defined $href->{proto};
   die "testService: state not defined"      unless defined $href->{state};
   die "testService: updated_on not defined" unless defined $href->{updated_on};
   die "testService: machine_updated not defined"
     unless defined $href->{machine_updated};

   my $service         = $href->{service};
   my $port            = $href->{port};
   my $version         = $href->{version};
   my $proto           = $href->{proto};
   my $state           = $href->{state};
   my $updated         = $href->{updated_on};
   my $machine_updated = $href->{machine_updated};


    row_ok( 
        sql   => "SELECT service FROM services WHERE mid = '1' and port=$port",
        tests => [ service => $service ],
        label => "Testing table:service port $port element:service");
    row_ok( 
        sql   => "SELECT port FROM services WHERE mid = '1' and port=$port",
        tests => [ port => $port ],
        label => "Testing table:service element:port");
    row_ok( 
        sql   => "SELECT protocol FROM services WHERE mid = '1' and
port=$port",        
        tests => [ protocol => $proto ],
        label => "Testing table:service element:protocol");

    row_ok( 
        sql   => "SELECT state FROM services WHERE mid = '1' and port=$port",
        tests => [ state => $state ],
        label => "Testing table:service element:state");

    row_ok( 
        sql   => "SELECT version FROM services WHERE mid = '1' and port=$port",
        tests => [ version => $version ],
        label => "Testing table:service element:protocol");

    row_ok( 
        sql   => "SELECT machine_updated FROM services WHERE mid = '1'  and
        port=$port",
        tests => [ machine_updated => $machine_updated ],
        label => "Testing table:service element:machine_updated");

    row_ok( 
        sql   => "SELECT updated_on FROM services WHERE mid = '1' and port=$port",
        tests => [ updated_on => $updated ],
        label => "Testing table:service element:updated_on");
 }


sub testServiceChange{
 my ($href) = @_;

   die "testService: port not defined"      unless defined $href->{port};
   die "testService: service not defined" unless defined $href->{service};
   die "testService: version not defined"    unless defined $href->{version};
   die "testService: proto not defined"  unless defined $href->{proto};
   die "testService: state not defined"      unless defined $href->{state};
   die "testService: updated_on not defined" unless defined $href->{updated_on};   die "testService: machine_updated not defined"
     unless defined $href->{machine_updated};

   my $service         = $href->{service};
   my $port            = $href->{port};
   my $version         = $href->{version};
   my $proto           = $href->{proto};
   my $state           = $href->{state};
   my $updated         = $href->{updated_on};
   my $machine_updated = $href->{machine_updated};

    row_ok(
        sql   => "SELECT service FROM services WHERE mid = '1' and port=$port",
        tests => [ service => $service ],
        label => "Testing table:service port $port element:service");
    row_ok(
        sql   => "SELECT port FROM services WHERE mid = '1' and port=$port",
        tests => [ port => $port ],
        label => "Testing table:service element:port");
    row_ok(
        sql   => "SELECT protocol FROM services WHERE mid = '1' and
port=$port",
        tests => [ protocol => $proto ],
        label => "Testing table:service element:protocol");
    row_ok(
        sql   => "SELECT state FROM services WHERE mid = '1' and port=$port and machine_updated=$machine_updated",
        tests => [ state => $state ],
        label => "Testing table:service element:state");

    row_ok(
        sql   => "SELECT version FROM services WHERE mid = '1' and port=$port",
        tests => [ version => $version ],
        label => "Testing table:service element:protocol");

    row_ok(
        sql   => "SELECT machine_updated FROM services WHERE mid = '1'  and
port=$port and machine_updated=$machine_updated",
        tests => [ machine_updated => $machine_updated ],
        label => "Testing table:service element:machine_updated");

    row_ok(
        sql   => "SELECT updated_on FROM services WHERE mid = '1' and port=$port and machine_updated=$machine_updated",
        tests => [ updated_on => $updated ],
        label => "Testing table:service element:updated_on");
 }

