# Phatch - Photo Batch Processor
# Copyright (C) 2007-2010 www.stani.be
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see http://www.gnu.org/licenses/
#
# Phatch recommends SPE (http://pythonide.stani.be) for editing python files.

# Embedded icon is created by Stani, but derived
# from Igor Kekeljevic (http://www.admiror-ns.co.yu).

# Based on Stani's colorize
# Copyright (C) 2010 by Pawel T. Jochym <jochym@gmail.com>, www.stani.be

# Make a colorized version of the image with midtone shifted to
# prescribed color value.

# Follows PEP8

from core import models
from core.translation import _t


#---PIL
def init():
    global Image, ImageMath, ImageColor, imtools
    import Image
    import ImageMath
    import ImageColor
    from lib import imtools


def warmup(image, midtone, brighten, amount=100):
    """Apply a toning filter. Move the midtones to the desired
    color while preserving blacks and whites with optional mixing
    with original image - amount: 0-100%"""

    mode = image.mode
    info = image.info

    if image.mode != 'L':
        im = imtools.convert(image, 'L')
    else:
        im = image

    if image.mode != 'RGBA' and imtools.has_transparency(image):
        image = imtools.convert(image, 'RGBA')

    luma = imtools.convert(imtools.split(im)[0], 'F')
    o = []
    m = ImageColor.getrgb(midtone)
    b = brighten / 600.0
    # Calculate channels separately
    for l in range(3):
        o.append(ImageMath.eval(
            "m*(255-i)*i+i",
            i=luma,
            m=4 * ((m[l] / 255.0) - 0.5 + b) / 255.0).convert('L'))

    colorized = Image.merge('RGB', tuple(o))

    if imtools.has_alpha(image):
        imtools.put_alpha(colorized, imtools.get_alpha(image))

    if amount < 100:
        colorized = imtools.blend(image, colorized, amount / 100.0)

    return colorized


#---Phatch
class Action(models.Action):
    label = _t('Warm Up')
    author = 'Pawel T. Jochym'
    email = 'jochym@gmail.com'
    init = staticmethod(init)
    pil = staticmethod(warmup)
    version = '0.2'
    tags = [_t('filter'), _t('color')]
    __doc__ = _t('Colorize midtones of an image')

    def interface(self, fields):
        fields[_t('Midtone')] = self.ColorField('#805d40')
        fields[_t('Brighten')] = self.SliderField(50, 0, 100)
        fields[_t('Amount')] = self.SliderField(50, 1, 100)

    icon = \
'x\xda\x01<\n\xc3\xf5\x89PNG\r\n\x1a\n\x00\x00\x00\rIHDR\x00\x00\x000\x00\
\x00\x000\x08\x06\x00\x00\x00W\x02\xf9\x87\x00\x00\x00\x04sBIT\x08\x08\x08\
\x08|\x08d\x88\x00\x00\t\xf3IDATh\x81\xd5\x99[\x8c\x1cW\x99\xc7\x7f\xe7\x9c\
\xaa\xea\xee\xe9\x99\xe9\xb6\xe3\x9e\x19\xdb\xe3\xc4L\xb2\x8e\xe3\xc0\x06\
\xcb(\xc8\x0eV\x1c6\xe1\x92Ea\xa5$O\xac\x16!q\x91\xd8e\xb5\xcb\x03\x12O\xc6Z\
EBB\x82\x07\x82\x84\x90\x88\x04\n\x02\x02/\\6\x91 \xa0\x80H\x16\x89\xe0A\x89\
3\xb9cl\x8f\xed\x99\xee\x99\xe9{\xd7\xed\\x\xa8j3\xce\xc6\xc6\xe3i\x07q\xa4\
\xa3\xea\xea:U\xdf\xffw\xbe\xef\xabs)\xe1\x9c\xe3\xef\xb9x\xd7\xf4\xe9\x7f\
\x12E^f\x0f>\x05,\xafp\xb7k\x8f\xda\x84\x18\xa9\x07~/|V\xf8\x0f"\x1e$\xe6\
\x1fI)\xa3\n \x14$\x03P$\x04\xbc\xce8?f\x82/s\x87\xabo\xd6\xe4\xe8\x00~.\x0e\
\xd3\xe5\xbb\xb8\xf2N\xb6\xdc\x06c\xbb\xa0X\x03U\x06\x1c\xa4\x03\x88\x1b\xd0\
_\x82\xd5\xe7@7\xfbL\xf1Y\xeeq\xdf\xf8\xdb\x02|AH\x0e\xf25\xfa\x85\x8f\xb3\
\xf5\xdd\x1e\xd5[@\x15@\x06 }\x10\x1eX\r.\x05\x9d\x80\xcd\x8f\x9d\x93\xd0x\
\x16J\x9d_Q\xe6~\xeev\xabo=\xc0\xafE\x8d&\xbf\xc5\xf8sl\xbf\x07J\xd3\xa0\xfc\
L\xb8\xf4\xb2\xd0A\x00\x0e\xac\xc9\xc4\x1b\r:\x87\x88\xbbp\xee\x97`{\x1d\xb6\
\xf1a\xde\xe7\x9e\xda\xa8\x04y\xf5\xea\x81.\x8f\x912G\xed \x14\'A\xa6 \x12\
\x901\x88\x08d\x08r\x00b\x00"\x04\x11gU& 5\xf8\x1eL\x1f\x04\xebO\xd2\xe2{<!\
\no\x1d\xc0\x93\xe2\x93\x84\x1c\xa1P\x86R%\x17\x96W\x11\x82\x1ad\xe2\x87\x00\
2\xcc\xa0\x86\x10"\xce`=\tc\xd7A\xc84\x96o\xbf5\x00\xbf\x15\xd3t\xf8\x12\x1e\
P\xde\xbaNP\xde\xeb*\xcc{|(~\xddQ\x86@\x0eB\x0eQ\xaafJ\x1a<\xc0/\xc4\xbd\x1b\
\x91ru\xe3\xc0\x1a\x8f\xe2\x98D\x01$\xb9x\rR\x81\x94 $(\x01Bd\xed\x1d\x80\
\x05\xe7@X\x90\x06\xb4\x01L\x96\x1b.\xce\x00\x0c\x92U\x1e\x01f\xaeT\xca\xc6=\
\xf0\x84(\x10r\x18\x99\xdfm\xd6\xc0EY\x8f\x13^\x1c>j\xb0.\x94\xf2|`\x90\xb5#\
\xcak\x08z\x95\x0b\xcf\x1b0\xcd\xcf\xc4\xddW*g\xe3\x1eP\xfc\x9bs\x14\x90y\
\x07\x8b\x14\xf4Y\xf0\xb7e\nD~A\t\x90"\xef}\x97\x1d\xb5\xcd\x7f[\xc0f\xbdo\
\xfa`\xba\x99\xf8\xdcaD|\x02x\xf2\xda\x00\xa4\x1c\x8a\x8b\x8a\xb4\xecS\xb41\
\xbep\x90,B`\xc1\xafd*\x84\xcc\x04\xf9\x02,\x90\xe6\xafj\x91\x8b\x1fV\x13Ax\
\x16\xe4\x1b^\xe5\x9a[\xafT\xce\xd5\xe4\xc0v\xa3$\xc9X\x85Tj&\x07kx8H\xce\
\x81\xec\x82\xaa\x82\xf53\xe1n\x98\x03\xb9\x07\xac\x03k\xc1\x18H:\x10u\xb3ko\
,\x9a\xad\xd7\x0e\xc02.\x04\xd8\xa0\x82+\x8e\xd3\xf1\x04[\xbb+\xb0\x0c\x94\
\xba0\xd3\x05\x8a@\x00\xd6\x83:\xf0l\x04w\x15!\xd5\x90\xa6\x90D\xa0\x1d\xfc\
\t\x98&\x83\xbd\xd8\xc6\x15\x8f\x07\x1bOb\x8f\xe3A\xa8q\xd2\x83\xb1=\xe8\x89\
\x9b\xe9\x95J\xf0\n\xf0#\xa0\t\xa4\x11\xc4\x1dXZ\x83G\xd7\xe0\xe4\x00\x9e\\\
\xcbz]\x87\x99\xf8\xdf\x03\xcf\x00\x86\xcc;\xc3\nP\xe4\xb5+\x97\xb3q\x80\x9f\
x\x89\xfb\x8cHB\x84?\x83(\xde@\xa8W(\xefx\x19\xf1:\xf0\x18\xb0\x97,!_\x06\
\x8e\x00\xbb\x80\'\x80\x1f\x00\xd7\x03g\x806\xb0-og\xc8\xbc0\xf4D\x81_]\xa9\
\x9c\x8d{\xe0\x1e~\x81$\x0e:\xab8\xdd\xa14q/\xae\xfcN\xba\xbb\xcb\xd9\xf5\
\x7f!\x8b\xa0"\xf0@.X\x00\xef\x07\xf6\x031p\x0b\xf06\xb2\xb7\xbd\xcb\x01\xcc\
:\x1b\x05~p\xed\x00p\x96\x12O\x8f5{\xb8\xee\xab\xe0\x1c~\xf9\x0e\xe2\xca\x0e\
\x98\x00:d\x1e\xb8\x05\xf0\x814\x17\x9d\x00S\xc0;\xf2\xe3\xb9\xfc8\x14?\xec\
\xfd1\x16y\xaf\xfb\xdd5\x04\x00\x14\x1f\xf3S\x1b\xcb\xd6\x1f\x19\xb4\xfe\x17\
\xdf\xdb\x85\x0bv\x91\xecTYx$\xb9\xe8\xe1X\x95\xe4 \xc3c/\xff\xbf\x94\x9f\
\xe7\xc3\x03\x02\xc7\x04\xff\xbe\x11)W\x07\xf0\xcf\xee4\x93|s\xf2\xfc\x12v\
\xf5i\x92\xfe\x1f@m%\xdeU\x82\xb3\xb9\xd0a\x1dz ^\x07q\x06\xa8e\xe7\x9d\xea\
\x04z8\xe5\xa8\xf2\x0c\x1ft?\xbe\xf6\x00\x003\xfcW`M=Xz\x11\xdd\xfc?H#\x92\
\xe9\x89,9C\xfe\x126C\xe1\xc3\xf3\x048\x0fl\x83\xc6\xde;\x88j\xfb\xf0R\x07\
\x1e1\x93|t\xa32\xae\x1e\xe0\x80K\xd9\xc6\x87*+\xcdD6\x16\xa0\xb7\x98\xcd\
\xd7\xaadc\xc2z/\xac\xef\xfd\x18X\x83\xc6{\xee\xa1p\xfd\xa7\x19?5\x9f\x85\
\xce4\xff\xc9]\xee\xf5\xb7\x0e\x00\xe0\xbd\xeewb+\xff=\xb9t\xdeyk\x8b\xc80\
\xc2n\x15\xb0\xf4&\x00C\x0f\xd4!\x9d*\xe0\xef\xf80z\xfe\xb3\x8cu\x13\xb8\x8e\
\xef\\\xed\xdax4\x8b\xfa\x9f\x8aG\xe3\xbe\xfa\x88\x0e\x14\xc5z\x82:\x01\x1c\
\xb8D\xdb\xd7\xa0;\xb7\x03;\xd3\xa7Ro\xc3\x04\'\xb8\xdf\xbd\xe3jMo\xce\x03\
\xc3\xf2!\xf7\xaf\x05\xcf\xbc4\xd6IP\x05\xb2\x9e\xd6\x97h\xbb\x02c\xe6\\&>\
\xa0\xc3\x0c\xff\xb4\x19\xd3\xa3\x01\x00\x18\xe7[b\xe8\xcc*\xd9\x94\xe2\x8d\
\xa5\x0f\xa8l\xdd\x9f\xdf\xf3\x9b\xcd\xee\r\x8d\x0e\xa0\xc8\x0f/\xfc\xde\x02\
\xb4\xde\xa4\xcd*p\xdd\xba\xf3\x80_n\xd6\xec\xe8\x00\xeet\xaf\xa1H\x81\x0c`\
\x95l\xf1\xd5\xcd\xeb\x00h\xe4\xd7\x86Eq|\xb3fG\xba7j\x03\xd5\x92-S\xa3\x0e\
\x14\xc8\xa6\xd2\xc3U\x96#\x1bq;\x80\x0fnR\x18\xb1\xc5\xbd\xb8Y\x9b#\x05\xf8\
a\xfa\x95\xe2\xa1\xeb\xbe\xce6y\x8a`<D\xa6\xf6/\xc9\xac\xc0\xdd(\x88\x03\x8f\
\xfax\x95\xef\xbfzX\xad.\xfc\xc3\xf5_|\x17K\x9b\xb19R\x00\xe7O\xf1\xac\xf7\
\x10\xabr\x15S6\x08\xbd\xc66\xef\x150\x03^_\xadQ_-\x11\x86!\xd6f3\xb7\x89\
\x89\xcd\x87\xf0hC\xc8Z:\x9d\x0e\xbbw\xef\xa6T*\xd1\xeb\xf58{v\x9a\x95\xf6\n\
\xdd\xa4K6\x83\x1bm\x19\xf9\xf7\x81\x99\x99\x19\x96\x97\x97\xe9\xf5z\x08!(\
\x95JLMM\x11\x04\x01\xcdf\x930\x0cGjo\xa4\x00\x85BA\x9c9s\x86\x9d;wr\xf3\xcd\
7\x13\xc71\xe7\xcf\x9fgii\x89^\xafG\x1c\xc7\xa34\x07\x8c\x18\xa0\xd7\xeb\xd9\
\x1bn\xb8\x81~\xbf\xcf\xf1\xe3\xc7\x89\xa2\x08\xcf\xf3\x90R\xe2\xfb>\x9e7\
\xfa\x0fB#}\xe2\xca\xcaJ7\x8a\xa2\xc9j\xb5\xca\xde\xbd{\xd1Z\xd3\xeb\xf5\xa8\
\xd7\xb3\xc1v\x98\xbc\x00B\x08\x93\xa6\xe9\xe2fm\x8e\x14\xe0\xf9\xe7\x9f\xff\
\xfc\x8e\x1d;\xbe\xad\xb5\xa6\xd5j\x11\xc71I\x92\xe0\x9c#\x8a"\xac\xb5\x08!p\
\xce\xd1\xef\xf7\x1f{\xf8\xe1\x877\r0\xdaod\xc0}\xf7\xdd\xf7u)\xe5\xa7\x8a\
\xc5"\x85B\x01\xdf\xf7\x11B\\\x80\x89\xe3\x18c\xcc\xb3Z\xeb\xf7<\xfe\xf8\xe3\
\x9bN\x8a\xd1M%\xf2r\xe0\xc0\x81O\x1bc>\xd7l6\xdb\xcdf\x93z\xbd\xce\xf2\xf22\
\xadV\x8bv\xbbm\x8c1_\xf5<\xef\x03\xa3\x10\x0f\x1b\xf7\x80X\x7fr\xec\xd81q\
\xa9\x86\x0f=\xf4\xd0\xdb\xad\xb5\x7f(\x16\x8bBJI\x14Eh\xad\xbfp\xf4\xe8\xd1\
\xff\xb9\xd4=G\x8f\x1e}\xa3\x98\xbf*\xeeJ\x00\xc4P\xec\xbe}\xfb\xc4\xdc\xdc\
\x9c\xacT*rqqQ4\x1a\r\xd1l6E\xa7\xd3\x11\xfd~_\xd4j5\x1a\x8d\x86\x04\x08\xc3\
P<\xf2\xc8#\xef\xeat:wYk\xb7\x15\x8b\xc5g\x0e\x1e<\xf8\xb3C\x87\x0e\rJ\xa5\
\x92\x1b\x1f\x1fw\x13\x13\x13nyy\x99\xc9\xc9I\xb7e\xcb\x16W\xab\xd5\xdc\xec\
\xec\xac\x9b\x9f\x9fw\xb5Z\xcd\x1e9rd\xb8_qI\xa0\xcb\x01\x88c\xc7\x8e\x89;\
\xef\xbcSNMM\xc9\x17^xA5\x1a\r\xd5\xedvU\xbb\xdd\xf6\xd24UZk\xd5\xeb\xf5T\
\x92$2\x0cC\x15\xc7\xb1\xd2Z\xcb$I\x94RJ\x1ac\xa4s\xd9\x0e\xaf\x10\xc2)\xa5\
\xac\xe7y\xd69g<\xcf\xb3\x85B\xc1\x94J%\x13\x04\x81\x1d\x1f\x1f7\xd5j\xd5\
\x00\xb6R\xa9\xe8 \x08\xf4\xfe\xfd\xfbM\xadV\xb3\xedv\xdb\x1e8p`\xfd&\xe4_\
\x05\x10\x80XXX\xf0\x16\x17\x17\xfdv\xbb\xed\x9d>}\xda?q\xe2\x84w\xee\xdc9\
\xbf\xd5jy\x9dN\xc7O\xd34\xd0Z\x07\xc6\x18\xdfZ\xeb\x0b!|\xe7\x9co\xad\xf5\
\x9cs\x9esn\xf8\x99\x12\xc0\t!\x8c\x10BK)u~L\x9ds\x89R*UJ\xa5\xbe\xef\'\x95J\
%)\x16\x8bznn.\xdd\xbd{\xb7\xbe\xed\xb6\xdbt\xb5Z\xd5\xb3\xb3\xb3\xe9\xfc\
\xfc\xbc~\xf0\xc1\x07/\xf2\xca\xe5^\xa32\x0cCOJ\xe9-,,\xf8\xcf=\xf7\x9c\x7f\
\xf2\xe4\xc9\xa0\xd1h\x04\xadV+\xb0\xd6\x16\x92$)\x92M\x9c\x0b\xce\xb9\x02PP\
J\x05\xf9o/\xaf*\x7f\x9e%\xdb\x83K\x81\xc4Z{a\xb9/\x84\x88\x81(\x08\x82xqq1\
\xaeV\xabq\xab\xd5\xf2N\x9f>\x9d,--\xc9\xc3\x87\x0f\x8b\xa9\xa9)n\xbd\xf5\
\xd6\xe1\xa4\xfcB\xb9\xec80==\xed\x9a\xcdlm\xa8\x94r\xe5r\xd9%I\xe2\x06\x83\
\x81\x8b\xa2\xc8\t!\xacs\xc3\xcf-Y5\xc6\x0c\x85\xca\xfc\xdaE+\x02!.,</\x19\
\xbb\xce\xb9+~;^\x0e\xc0.//\xebr\xb9\xcc\xed\xb7\xdf\xeefgg\xedK/\xbddO\x9d:\
e*\x95J\xda\xe9t\xe2$I\xfc4M\x03c\x8c?\x0c#\xe7\x9c\xf7&!$\xd6\x01\x98\xf5!$\
\xa5\xd4J\xa9\xc4\xf3\xbc\xd4\xf3\xbctrr2\x9d\x99\x99\xd1\xdb\xb7oO\xf7\xec\
\xd9\x93\xdex\xe3\x8d\xbaZ\xad\xea \x08\xd2\xf9\xf9y\xb3o\xdf\xbe\x8bD^6\x89\
\x01\x9ez\xea)555%\xeb\xf5\xba\xec\xf5zraaAYk\xbd\x95\x95\x15%\x84\x90\x9dNG\
EQ$\x93$\x91Q\x14\xa94M\xa5\xd6Zj\xad\xa51FZk\x05\x80\x94\xd2\t!\x9c\x94\xd2\
y\x9eg\x83 0J)W,\x16/$\xf1\xd8\xd8\x98\xf5}\xdfT*\x15=11aj\xb5\x9a\xd9\xbf\
\x7f\xbf\xbd\xe9\xa6\x9b\x86\xdb\xbf\xff/\x89\xff\x0c+n\xee\x9f\x92\x99\xec6\
\x00\x00\x00\x00IEND\xaeB`\x82\x17\xa5\xee\xc4'
