/*	LAFs

CVS ID: LAFs.java,v 1.3 2012/04/16 06:22:59 castalia Exp

Copyright (C) 2008-2012  Arizona Board of Regents on behalf of the
Planetary Image Research Laboratory, Lunar and Planetary Laboratory at
the University of Arizona.

This file is part of the PIRL Java Packages.

The PIRL Java Packages are free software; you can redistribute them
and/or modify them under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation, either version 3 of
the License, or (at your option) any later version.

The PIRL Java Packages are distributed in the hope that they will be
useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.

*******************************************************************************/

import	PIRL.Viewers.View_Locator;
import	PIRL.Viewers.Dialog_Box;

import	javax.swing.*;
import	java.awt.event.ActionListener;
import	java.awt.event.ActionEvent;
import	java.util.Vector;


public class LAFs
	extends JFrame
{
public static final String
	LAF_NAMES[][] =
		{
		{"Motif", 		"com.sun.java.swing.plaf.motif.MotifLookAndFeel"},
		{"Java/Metal",	"javax.swing.plaf.metal.MetalLookAndFeel"},
		{"Basic",		"javax.swing.plaf.basic.BasicLookAndFeel"},
		{"GTK",			"com.sun.java.swing.plaf.gtk.GTKLookAndFeel"},
		{"Synth",		"javax.swing.plaf.synth.SynthLookAndFeel"},
		{"XAWT",		"sun.awt.X11.XAWTLookAndFeel"},
		{"Windows Classic",
			"com.sun.java.swing.plaf.windows.WindowsClassicLookAndFeel"},
		{"Windows",		"com.sun.java.swing.plaf.windows.WindowsLookAndFeel"}
		};


private Vector
	LAF_Names = new Vector ();
private JComboBox
	LAF_List;


public LAFs ()
{
super ("LAFs");

UIManager.LookAndFeelInfo[]
	info = UIManager.getInstalledLookAndFeels ();
for (int
		index = 0;
		index < info.length;
		index++)
	LAF_Names.add
		(info[index].getName () + " - " + info[index].getClassName ());

for (int
		index = 0;
		index < LAF_NAMES.length;
		index++)
	if (not_listed (LAF_NAMES[index][1]))
		LAF_Names.add
			(LAF_NAMES[index][0] + " - " + LAF_NAMES[index][1]);

JPanel
	contentPane = new JPanel ();
setContentPane (contentPane);

LAF_List = new JComboBox (LAF_Names);
LAF_List.setEditable (false);
LAF_List.addActionListener (new ActionListener ()
	{public void actionPerformed (ActionEvent event)
	{LAF_Selection ();}});
contentPane.add (LAF_List);

setDefaultCloseOperation (JFrame.EXIT_ON_CLOSE);
pack ();
}


private void LAF_Selection ()
{
String
	name = (String)LAF_List.getSelectedItem ();
int
	index = name.indexOf ('-');
String
	message = View_Locator.Select_LAF (name.substring (index + 2));
if (message == null)
	{
    SwingUtilities.updateComponentTreeUI (this);
	pack ();
	}
else
	Dialog_Box.Error
		("Unable to set LAF -\n"
		+ name + "\n\n"
		+ message,
		this);
}


private boolean not_listed
	(
	String	name
	)
{
if (name == null ||
	name.length () == 0)
	return false;

for (int
		index = 0;
		index < LAF_Names.size ();
		index++)
	{
	String
		entry = (String)LAF_Names.get (index);
	if (entry.indexOf (name) >= 0)
		return false;
	}
return true;
}


public static void main
	(
	String[] arguments
	)
{
LAFs
	window = new LAFs ();
window.setVisible (true);
}

}
