/*
 *  PlanFacile (Easy plan, in french) is a small tool to help people to
 *  write a document on a particular subject.
 *  Copyright (C) 2005  Julien BRUGUIER
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef __PROBLEME__
#define __PROBLEME__

#include <src/global/global.h>

#include <src/messages/messages/sources/messages.h>
#include <src/messages/messages/sources/messageparametres.h>
#include <src/donnees/general/general.h>
#include <src/donnees/environnement/environnement.h>
#include <src/donnees/environnement/options/options.h>
#include <src/donnees/commandes/localisationfichier.h>

typedef enum {
	PROBLEME_MEMOIRE_INSUFFISANTE,
	//Correspond au cas o une fonction renvoie RESULTAT_ERREUR_MEMOIRE
	//Ce problme requiert l'utilisation de :
	PROBLEME_RECURSIVITE_FICHIER,
	//Correspond  une boucle dans les inclusions de fichiers.
	//Ce problme requiert l'utilisation de :
	//	- le nom du fichier incrimin.
	PROBLEME_RECURSIVITE_FICHIER_STANDARD,
	//Correspond  une boucle dans les inclusions de fichiers
	//dans le cas de la commande #standard.
	//Ce problme requiert l'utilisation de :
	//	- le nom du fichier incrimin.
	PROBLEME_OPTION_LIGNE_COMMANDE,
	//Correspond  la dcouverte d'une option non reconnue dans
	//la ligne de commande.
	//Ce problme requiert l'utilisation de :
	//	- le caractre de l'option non reconnue.
	PROBLEME_UTILISATION_SORTIE,
	//Correspond au cas o l'option -o est utilise deux fois
	//dans la ligne de commande.
	//Ce problme requiert l'utilisation de :
	PROBLEME_OUVERTURE_SORTIE,
	//Correspond au cas o le fichier prcis en sortie ne peut
	//tre ouvert en criture.
	//Ce problme requiert l'utilisation de :
	//	- nom du fichier incrimin.
	PROBLEME_OUVERTURE_REPERTOIRE_COURANT,
	//Correspond au cas o le rpertoire courant de planfacile est
	//incorrect.
	//Ce problme requiert l'utilisation de :
	PROBLEME_OUVERTURE_CHEMIN_INVALIDE,
	//Correspond au cas o le chemin vers le source est invalide.
	//Ce problme requiert l'utilisation de :
	//	- nom du fichier incrimin
	PROBLEME_OUVERTURE_CHEMIN_INVALIDE_STANDARD,
	//Correspond au cas o le chemin vers le source est invalide,
	//dans le cas de la commande #standard.
	//Ce problme requiert l'utilisation de :
	//	- nom du fichier incrimin
	PROBLEME_OUVERTURE_INEXISTANT,
	//Correspond au cas o le fichier source est introuvable.
	//Ce problme requiert l'utilisation de :
	//	- nom du fichier incrimin
	PROBLEME_OUVERTURE_INEXISTANT_STANDARD,
	//Correspond au cas o le fichier source est introuvable,
	//dans le cas de la commande #standard.
	//Ce problme requiert l'utilisation de :
	//	- nom du fichier incrimin
	PROBLEME_OUVERTURE_TYPE_INCORRECT,
	//Correspond au cas o le fichier source este type incorrect
	// (rpertoire ou fichier de type block)
	//Ce problme requiert l'utilisation de :
	//	- nom du fichier incrimin
	PROBLEME_OUVERTURE_TYPE_INCORRECT_STANDARD,
	//Correspond au cas o le fichier source este type incorrect
	// (rpertoire ou fichier de type block),
	//dans le cas de la commande #standard.
	//Ce problme requiert l'utilisation de :
	//	- nom du fichier incrimin
	PROBLEME_OUVERTURE_ENTREE,
	//Correspond au cas o un fichier prcis en entre ne peut
	//tre ouvert en lecture.
	//Ce problme requiert l'utilisation de :
	//	- nom du fichier incrimin.
	PROBLEME_OUVERTURE_ENTREE_VIDE,
	//Correspond au cas o un fichier prcis en entre est vide.
	//Ce problme requiert l'utilisation de :
	PROBLEME_OUVERTURE_ENTREE_STANDARD,
	//Correspond au cas o un fichier prcis en entre de la
	//commande #standard ne peut tre ouvert en lecture.
	//Ce problme requiert l'utilisation de :
	//	- nom du fichier incrimin.
	PROBLEME_OUVERTURE_STANDARD,
	//Correspond au cas o la commande standard ne peut ouvrir
	//aucun fichier.
	//Ce problme requiert l'utilisation de :
	PROBLEME_OUVERTURE_STANDARD_SUIVANTE,
	//Correspond au cas o la commande #standard va se rabattre
	//sur un fichier de priorit infrieure.
	//Ce problme requiert l'utilisation de :
	//	- nom du fichier suivant test.
	PROBLEME_AVERTISSEMENT_UTILISATEUR,
	//Correspond  un avertissement explicitement demand par
	//l'utilisateur.
	//Ce problme requiert l'utilisation de :
	//	- le message de l'utilisateur.
	PROBLEME_ERREUR_UTILISATEUR,
	//Correspond  une erreur explicitement demande par
	//l'utilisateur.
	//Ce problme requiert l'utilisation de :
	//	- le message de l'utilisateur.
	PROBLEME_COMMANDE_INCORRECTE,
	//Correspond  une commande non autorise dans un flux donn.
	//Ce problme requiert l'utilisation de :
	//	- une chaine indiquant quelle commande est incrimine.
	PROBLEME_COMMANDE_TEXTE_INCORRECTE,
	//Correspond  une commande non autorise dans un flux donn.
	//Ce problme requiert l'utilisation de :
	PROBLEME_COMMANDE_ECHAPPEMENT_INCORRECTE,
	//Correspond  une commande non autorise dans un flux donn.
	//Ce problme requiert l'utilisation de :
	//	- un caractre reprsentant la commande incrimine.
	PROBLEME_COMMANDE_MACRO_INCORRECTE,
	//Correspond  une commande non autorise dans un flux donn.
	//Ce problme requiert l'utilisation de :
	//	- un nombre reprsentant le nom de la macro incrimine.
	PROBLEME_COMMANDE_PARAMETRE_INCORRECTE,
	//Correspond  une commande non autorise dans un flux donn.
	//Ce problme requiert l'utilisation de :
	//	- un nombre reprsentant la commande incrimine.
	PROBLEME_REDEFINITION_MACRO,
	//Correspond au cas d'une redfinition de macro.
	//Ce problme requiert l'utilisation de :
	//	- une chaine dcrivant quelle macro est incrimine.
	PROBLEME_MACRO_INCONNUE,
	//Correspond  la dcouverte d'un appel de macro dont la macro
	//est inconnue.
	//Ce problme requiert l'utilisation de :
	//	- une chaine dcrivant quelle macro est incrimine.
	PROBLEME_RECURSIVITE_MACRO,
	//Correspond  la dcouverte d'une rcursivit entre les macros.
	//Ce problme requiert l'utilisation de :
	//	- une chaine dcrivant quelle macro est incrimine.
	PROBLEME_PARAMETRES_MACRO,
	//Correspond  la dcouverte d'un appel de macro contenant un nombre
	//de paramtres incorrects.
	//Ce problme requiert l'utilisation de :
	//	- une chaine dcrivant quelle macro est incrimine,
	//	- un entier indiquant le nombre de paramtres trouvs,
	//	- un entier indiquant le nombre de paramtres demands.
	PROBLEME_OPTION_DANS_MACRO,
	//Correspond au cas o une commande de dfinition d'option
	//est dcouverte dans une dfinition ou un paramtre de macro.
	//Ce problme requiert l'utilisation de :
	//	- une chaine indiquant l'option dfinie,
	//	- une chaine prcisant le nom de la macro victime.
	PROBLEME_REDEFINITION_SECTION,
	//Correspond au cas o un niveau de format de section
	//est redfini.
	//Ce problme requiert l'utilisation de :
	//	- un entier indiquant le niveau modifi.
	PROBLEME_REDEFINITION_SECTION_DEFAUT,
	//Correspond au cas o le format de section
	//par dfaut est redfini.
	//Ce problme requiert l'utilisation de :
	PROBLEME_REDEFINITION_REFERENCE,
	//Correspond au cas o un niveau de format de rfrence
	//est redfini.
	//Ce problme requiert l'utilisation de :
	//	- un entier indiquant le niveau modifi.
	PROBLEME_REDEFINITION_REFERENCE_DEFAUT,
	//Correspond au cas o le format de rfrence
	//par dfaut est redfini.
	//Ce problme requiert l'utilisation de :
	PROBLEME_REDEFINITION_MESSAGE,
	//Correspond au cas o le format de message
	//est redfini.
	//Ce problme requiert l'utilisation de :
	PROBLEME_REDEFINITION_ENTETE,
	//Correspond au cas o le format d'entte de document
	//est redfini.
	//Ce problme requiert l'utilisation de :
	PROBLEME_REDEFINITION_PIED,
	//Correspond au cas o le format de pied de document
	//est redfini.
	//Ce problme requiert l'utilisation de :
	PROBLEME_REDEFINITION_RACINE,
	//Correspond au cas o le niveau racine est modifi.
	//Ce problme requiert l'utilisation de :
	PROBLEME_SECTION_NIVEAU_INCORRECT,
	//Correspond au cas o le niveau de la commande de
	//section est invalide.
	//Ce problme requiert l'utilisation de :
	PROBLEME_REFERENCE_NIVEAU_INCORRECT,
	//Correspond au cas o le niveau de la commande de
	//rfrence est invalide.
	//Ce problme requiert l'utilisation de :
	PROBLEME_RACINE_NIVEAU_INCORRECT,
	//Correspond au cas o le niveau de la commande de
	//dfinition du niveau racine est invalide.
	//Ce problme requiert l'utilisation de :
	PROBLEME_RACINE_NIVEAU_NON_DEFINI,
	//Correspond au cas o le niveau de la commande de
	//dfinition du niveau racine ne peut tre dtermin.
	//Ce problme requiert l'utilisation de :
	PROBLEME_REDEFINITION_IDEE,
	//Correspond au cas o une ide est redfinie.
	//Ce problme requiert l'utilisation de :
	//	- une chaine reprsentant la rfrence de l'ide.
	PROBLEME_IDEE_REFERENCE_VIDE,
	//Correspond au cas o une ide a une rfrence vide.
	//Ce problme requiert l'utilisation de :
	PROBLEME_IDEE_MANQUANTE_REFERENCE_VIDE,
	//Correspond au cas o une ide manquante a une rfrence vide.
	//Ce problme requiert l'utilisation de :
	PROBLEME_IDEE_GENERIQUE_REFERENCE_VIDE,
	//Correspond au cas o une ide gnrique a une rfrence vide.
	//Ce problme requiert l'utilisation de :
	PROBLEME_PERTINENCE_INCORRECTE,
	//Correspond au cas o la pertinence d'une dpendance est
	//incorrecte.
	//Ce problme requiert l'utilisation de :
	//	- une chaine indiquant quelle dpendance est concerne.
	PROBLEME_INDICE_IDEE_MANQUANTE_INCORRECT,
	//Correspond au cas o l'indice d'une ide manquante
	//est incorrect.
	//Ce problme requiert l'utilisation de :
	PROBLEME_REDEFINITION_IDEE_MANQUANTE_DEFAUT,
	//Cas o l'ide manquante par dfaut est redfinie.
	//Ce problme requiert l'utilisation de :
	PROBLEME_REDEFINITION_IDEE_MANQUANTE,
	//Cas o une ide manquante est redfinie.
	//Ce problme requiert l'utilisation de :
	//	- un entier donnant l'indice redfini.
	PROBLEME_INDICE_IDEE_GENERIQUE_INCORRECT,
	//Correspond au cas o l'indice d'une ide gnrique
	//est incorrect.
	//Ce problme requiert l'utilisation de :
	PROBLEME_REDEFINITION_IDEE_GENERIQUE_DEFAUT,
	//Cas o l'ide gnrique par dfaut est redfinie.
	//Ce problme requiert l'utilisation de :
	PROBLEME_REDEFINITION_IDEE_GENERIQUE,
	//Cas o une ide gnrique est redfinie.
	//Ce problme requiert l'utilisation de :
	//	- une chaine indiquant quelle ide est redfinie.
	PROBLEME_DEPENDANCE_INUTILE,
	//Cas o une dpendance ne peut tre utilise pour le calcul
	//du plan.
	//Ce problme requiert l'utilisation de :
	//	- une chaine indiquant quelle dpendance est concerne.
	PROBLEME_DEPENDANCE_VIDE_INUTILE,
	//Cas o une dpendance vide ne peut tre utilise pour le calcul
	//du plan.
	//Ce problme requiert l'utilisation de :
	PROBLEME_SANS_IDEE_ORPHELINE,
	//Correspond au cas o aucune ide orpheline n'est prsente dans
	//le graphe de dpendances.
	//Ce problme requiert l'utilisation de :
	PROBLEME_AJOUT_RACINE,
	//Correspond au cas o une ide racine est ajoute au graphe
	//de dpendances.
	//Ce problme requiert l'utilisation de :
	PROBLEME_IDEE_NON_ATTEIGNABLE,
	//Correspond au cas o une ide n'est pas atteignable depuis
	//la racine du graphe de dpendance.
	//Ce problme requiert l'utilisation de :
	//	- une chaine indiquant quelle ide est implique.
	PROBLEME_SECTION_STYLE_MANQUANT,
	//Correspond au cas o une section n'a pas de style de formattage.
	//Ce problme requiert l'utilisation de :
	//	- une chaine indiquant quelle ide est implique.
	PROBLEME_REFERENCE_STYLE_MANQUANT,
	//Correspond au cas o une rfrence n'a pas de style de formattage.
	//Ce problme requiert l'utilisation de :
	//	- une chaine indiquant quelle rfrence est implique.
	PROBLEME_IDEE_MANQUANTE_MANQUANTE,
	//Correspond au cas o une ide manquante n'est pas dfinie.
	//Ce problme requiert l'utilisation de :
	//	- un nombre reprsentant l'indice de l'ide demande.
	PROBLEME_IDEE_GENERIQUE_MANQUANTE,
	//Correspond au cas o une ide gnrique n'est pas dfinie.
	//Ce problme requiert l'utilisation de :
	//	- une chaine reprsentant l'indice de l'ide demande.
	PROBLEME_DEPENDANCE_INCORRECTE,
	//Correspond au cas o une dpendance pointe sur une ide incorrecte.
	//Ce problme requiert l'utilisation de :
	//	- une chaine reprsentant la rfrence de destination incrimine.
	PROBLEME_DEPENDANCE_VIDE,
	//Correspond au cas o la destination d'une dpendance est vide.
	//Ce problme requiert l'utilisation de :
	PROBLEME_INDICE_REFERENCE_INCORRECT,
	//Correspond au cas o l'indice d'une commande #extref est incorrect.
	//Ce problme requiert l'utilisation de :
	//	- une chaine reprsentant l'indice incorrect.
	PROBLEME_NOM_NIVEAU_INCORRECT,
	//Correspond au cas o l'indice de la commande #sec ne donne pas
	//un nom de niveau explicitement dfini.
	//Ce problme requiert l'utilisation de :
	//	- une chaine reprsentant l'indice incorrect.
	PROBLEME_ERREUR_SYNTAXE
	//Correspond au cas o l'on dcouvre une erreur de syntaxe dans
	//un fichier source.
	//Ce problme requiert l'utilisation de :
	//	- token incrimin.
} CONTENEUR_SCALAIRE(Probleme);

#include <src/problemes/probleme/erreur.h>
#include <src/problemes/probleme/avertissement.h>

Resultat probleme_probleme(TRAVAIL(General) general , TRAVAIL_SCALAIRE(Probleme) probleme , TRAVAIL(LocalisationFichier) localisationfichier , ...);
/* Annonce d'un problme. Le message est donn sur la sortie d'erreur.
 * Si la localisation est non vide, la position du problme est galement
 * donne.
 * Renvoie RESULTAT_ERREUR si general est vide.
 * Renvoie RESULTAT_ERREUR_MEMOIRE si une allocation choue.
 * Attention ! Les paramtres surnumraires sont les paramtres
 * du message correspondant au problme rencontr. Le nombre et le type
 * de ces arguments doivent absolument correspondre avec leurs spcifications,
 * sous peine de comportement indfini.
 */

Resultat probleme_message(TRAVAIL_SCALAIRE(Probleme) probleme , REFERENCE_SCALAIRE(Message) message);
/* Renvoie le message associ  un problme dtermin.
 * Si le problme n'est pas rpertori, RESULTAT_ERREUR est renvoy.
 */

Resultat probleme_localisation(TRAVAIL(General) general , TRAVAIL_SCALAIRE(DescripteurFichier) sortie , TRAVAIL(LocalisationFichier) localisationfichier);
/* Affiche le contenu d'une localisation de fichier sur la sortie indique,
 * en utilisant l'environnement contenu dans general.
 * Renvoie RESULTAT_ERREUR si general est NULL.
 */

#endif
