typedef unsigned char bool;
#define true    1
#define false   0

/*
 *	Parse string and replace escape sequences.
 *
 *  sending: true if it's a chat-send string which has different escape syntax
 *  out: string to write to, must point to a buffer the same size as
 *       input, may point to the same buffer as input.
 */
void tstr(char *out, bool sending, const char *input)
{
	while(*input) {

		/* Skip quotes. */
		if (*input == '"') {
			input++;
			continue;
		}

		/* ^ for control character. */
		if (*input == '^') {
			*out++ = *++input & 0x1f;
			if (*input) input++;

		/* Some escaped character. */
		} else if (*input == '\\') {
			  switch(*++input) {
			case '\n':
				break;
			case 'r':
				*out++ = '\r';
				break;
			case 'n':
				*out++ = '\n';
				break;
			case 'b':
				*out++ = '\b';
				break;
			case 's':
				*out++ = ' ';
				break;
			case 't':
				*out++ = '\t';
				break;
			case '-':
				/* Keep minus sign escaped. */
				*out++ = '\\';
				*out++ = *input;
				break;
			case '\\':
			case 'd':
			case 'p':
			case 'l':
			case 'c':
			case 'K':
				/* These are double escaped for chat_send(). */
				if (sending) {
					*out++ = '\\';
					*out++ = *input;
					break;
				}
				/*FALLTHRU*/
			default:
				/* See if its an octal number. */
				if (*input >= '0' && *input <= '7') {
					int val = *input - '0';
					while(*++input >= '0' && *input <= '7')
						val = 8*val + (*input - '0');
					input--;
					/* '\0' and '\\' are special. */
					if (val == 0 || val == '\\') {
						*out++ = '\\';
						*out++ = val ? '\\' : 'N';
					} else
						*out++ = val;
				} else
					*out++ = *input;
			  }
			  if (*input) input++;
		} else
			/* Just a normal character. */
			*out++ = *input++;
	}
	*out = 0;
}

/*
 *	The tstr stuff is so useful that we export it.
 *
 *      This function replaces "\n" with a new-line character etc.
 *      The data pointed to by str is over-written.
 */
void unescape(char *str)
{
	tstr(str, false, str);
}

