############################################################################
# Copyright(c) Open Law Library. All rights reserved.                      #
# See ThirdPartyNotices.txt in the project root for additional notices.    #
#                                                                          #
# Licensed under the Apache License, Version 2.0 (the "License")           #
# you may not use this file except in compliance with the License.         #
# You may obtain a copy of the License at                                  #
#                                                                          #
#     http: // www.apache.org/licenses/LICENSE-2.0                         #
#                                                                          #
# Unless required by applicable law or agreed to in writing, software      #
# distributed under the License is distributed on an "AS IS" BASIS,        #
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. #
# See the License for the specific language governing permissions and      #
# limitations under the License.                                           #
############################################################################

from typing import List

from lsprotocol.types import TEXT_DOCUMENT_DOCUMENT_COLOR
from lsprotocol.types import (
    Color,
    ColorInformation,
    DocumentColorOptions,
    DocumentColorParams,
    Position,
    Range,
    TextDocumentIdentifier,
)

from ..conftest import ClientServer


class ConfiguredLS(ClientServer):
    def __init__(self):
        super().__init__()

        @self.server.feature(
            TEXT_DOCUMENT_DOCUMENT_COLOR,
            DocumentColorOptions(),
        )
        def f(params: DocumentColorParams) -> List[ColorInformation]:
            return [
                ColorInformation(
                    range=Range(
                        start=Position(line=0, character=0),
                        end=Position(line=1, character=1),
                    ),
                    color=Color(red=0.5, green=0.5, blue=0.5, alpha=0.5),
                )
            ]


@ConfiguredLS.decorate()
def test_capabilities(client_server):
    _, server = client_server
    capabilities = server.server_capabilities

    assert capabilities.color_provider


@ConfiguredLS.decorate()
def test_document_color(client_server):
    client, _ = client_server
    response = client.lsp.send_request(
        TEXT_DOCUMENT_DOCUMENT_COLOR,
        DocumentColorParams(
            text_document=TextDocumentIdentifier(uri="file://return.list")
        ),
    ).result()

    assert response
    assert response[0].color.red == 0.5
    assert response[0].color.green == 0.5
    assert response[0].color.blue == 0.5
    assert response[0].color.alpha == 0.5

    assert response[0].range.start.line == 0
    assert response[0].range.start.character == 0
    assert response[0].range.end.line == 1
    assert response[0].range.end.character == 1
