## Distro

Fedora 32


## GSSAPI Impl

Kerberos 5 release 1.18.1 with gss-ntlmssp


## Connection Info:

Connecting to host using FQDN and a proper SPN setup. Using explicit credentials with the SPNEGO OID. The acceptor will
not be able to decrypt the values as it's not the principal assigned to the SPN so it will fallback to NTLM.


## Notes

* Because both NTLM and Kerberos are available they are in the original mechTypes list
* The preferred mech is Kerberos hence why the first message contains the AP REQ
* The acceptor is unable to decrypt the data (isn't the right SPN) so it returns back saying NTLM should be used
* It also sets REQUEST_MIC in the status which makes sense
* The exchange follows the typical NTLM exchange, each token has `ACCEPT_INCOMPLETE` until the last one from the acceptor


## Tokens

```yaml
MessageType: SPNEGO InitialContextToken
Data:
  thisMech: SPNEGO (1.3.6.1.5.5.2)
  innerContextToken:
    MessageType: SPNEGO NegTokenInit
    Data:
      mechTypes:
      - Kerberos (1.2.840.113554.1.2.2)
      - NTLM (1.3.6.1.4.1.311.2.2.10)
      reqFlags:
      mechToken:
        MessageType: SPNEGO InitialContextToken
        Data:
          thisMech: Kerberos (1.2.840.113554.1.2.2)
          innerContextToken:
            MessageType: AP-REQ (14)
            Data:
              pvno: 5
              msg-type: AP-REQ (14)
              ap-options:
                raw: 32
                flags:
                - mutual-required (32)
              ticket:
                tkt-vno: 5
                realm: DOMAIN.LOCAL
                sname:
                  name-type: NT-SRV-HST (3)
                  name-string:
                  - host
                  - dc01
                enc-part:
                  etype: AES256_CTS_HMAC_SHA1_96 (18)
                  kvno: 7
                  cipher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
              authenticator:
                etype: AES256_CTS_HMAC_SHA1_96 (18)
                kvno:
                cipher: E2E112513FD9F00F339741F83BA34415183DA1D35E3309CDBD4FDED5E3F59CC442352BBD4BA43379498D520B8F2D049D658E13A059D9212F0950A4A4D6A89C5092CF2ABEB137FF4E78205805BA7AD3C8D5405723F37A5B988CB8295856603C1C80D07E89B25824434865227FE9DEBF2979DA0F2BD238FE388A82697F8918B3771382508DD691CB55AA978EB4CD8A0ECFBFC912E56EC3231A7C710BE0B418A3AA149418354E66693B73AD20C4E96A5928BCE5E945DF9946EFDD796804EC6F4866F707842AEB6BC6CECD2D
            RawData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
        RawData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
      mechListMIC:
    RawData: A082058930820585A019301706092A864886F712010202060A2B06010401823702020AA2820566048205626082055E06092A864886F71201020201006E82054D30820549A003020105A10302010EA20703050020000000A3820457618204533082044FA003020105A10E1B0C444F4D41494E2E4C4F43414CA2173015A003020103A10E300C1B04686F73741B0464633031A382041D30820419A003020112A103020107A282040B04820407E47D9A50681C0AE687CC27B2424720A9C8BDDA258B93B6F9C3A3672806E3D0E1102A554E491F8B718B1017966621558ACB5D5D13B93AB0A50C81160817152AAAFFCB598B310933247327C8ADA5D2A28197779A2B818846E0BFAC47F10B0C024534E4AA6F833E9BB077C5714B6A3043AE8BAB45564C2A7C56792D1B3D41C5EE19ADCDE13C56B519419C75A020EC766AF8195CCBA2F4506B08E511AE411766D61DD79CF468513F04E831A9D5EB0900D7863D523E065E3A0A7CDDCCAD0E0F2068AE2B43C3C275485CD78D8A521BCE407DEF847D063A6149FD28F17FA48885786E3270A282D0F8C9885EA49304D47B9EB62E5E3B30EF5DCCC41B59F312B20421E88FFD2A094775A6C84A20B4C65AFFA42CC42A5FFD8FEBF0BA8A917AB812F4688824BE45C6DC81FEEA71F70E071BCA035179084B5D8D548287ACF581D3EFBA5097B1174EE165091904034F227EB6EA18B0AD6E6D1C3B26A73E38881EC43C3466600EAF2AFCC9E4D2D1A2CA8A38D47068C2D9B603D77F0FD6273574169701AA097ABFD840BBBAA790B8172055913869439BB42AA76769AFD6EE5CDC520BAF59B16C5B74436856AB91AD89F9D2A31F349A142BCA2243C1744ADB16C11CF544A1DB6428BC90E68ED2A7F23CB512F3C35F25B4DF7E7B478711DDB38FD6E3E2F0FA3E0B01B950A245E9617CD7ACD787C7E103526BF9625421E3B5C5639F576041DB93C479FC5C0DCC42F49350FF1CFA8427ACD251B196E1E2D40CD2F91EBB6E3DE1B0479E4CD5B50339AE45D82494CC496CFFECA79D1D09195DAEDFDBE2E88363FF12D189EE3BE37856986FAB0AC7062273F7F1F099A3EB2C26EC9539C57202990F26B26CC6C10F251561DAF9934549479B9E34CA445E0E293F774A21E0452EC553BA9F7F7468154E5B2774DA4D822CD752875BC606452A664D39CC53DE94D011A1EA140A210A4E6E0631162CB4DFCBD9E486C5FA7BF17309CA6FE5781496C98B32DA8EF29F37B56AE5E38F87877BB18155D3298AD97E1D390D2E9DAE35BDE4C1AD5B22C10C538F9438ED75B57A69F25C8C7719EF164FAFC2C172236337A1259F5AEB607D1432BFD04472BC367447E65EA43647BF29EF4DB590E30BADE97A52B8B9BB87A07CE33253BDECB6BE8280ED820F481B572553192EA1A6F3762FF6FD88E20940E0BFA36F9A230C5C2878F29A30E0AA63E5C691F693FC4C66678689C418280CC9B6B7243E44C767D0E92D9AB6960BB3009CC763EDB392E44277B87520D05BA732564F3D5D334763CB096FF0799CE763A5E075EDB326106FE2685A0D7443CE717D564881EE1D51519FEDC53E39CD91F92C3A82EA6523536C11FBC7097138216ECEEABC88E1D11DE7B7DDDE622D9A745823F3D9207ACE99F322FA5568B4632ED4FC738C6FEA89CA832C59C45D5A78300AC5FBBF8B377189A90858C42090A2F1095F310A0556B3798D59A481D83081D5A003020112A281CD0481CAE2E112513FD9F00F339741F83BA34415183DA1D35E3309CDBD4FDED5E3F59CC442352BBD4BA43379498D520B8F2D049D658E13A059D9212F0950A4A4D6A89C5092CF2ABEB137FF4E78205805BA7AD3C8D5405723F37A5B988CB8295856603C1C80D07E89B25824434865227FE9DEBF2979DA0F2BD238FE388A82697F8918B3771382508DD691CB55AA978EB4CD8A0ECFBFC912E56EC3231A7C710BE0B418A3AA149418354E66693B73AD20C4E96A5928BCE5E945DF9946EFDD796804EC6F4866F707842AEB6BC6CECD2D
RawData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
```

```yaml
MessageType: SPNEGO NegTokenResp
Data:
  negState: request-mic (3)
  supportedMech: NTLM (1.3.6.1.4.1.311.2.2.10)
  responseToken:
  mechListMIC:
RawData: A1153013A0030A0103A10C060A2B06010401823702020A
```

```yaml
MessageType: SPNEGO NegTokenResp
Data:
  negState: accept-incomplete (1)
  supportedMech:
  responseToken:
    MessageType: NEGOTIATE_MESSAGE (1)
    Data:
      NegotiateFlags:
        raw: 3758654007
        flags:
        - NTLMSSP_NEGOTIATE_56 (2147483648)
        - NTLMSSP_NEGOTIATE_KEY_EXCH (1073741824)
        - NTLMSSP_NEGOTIATE_128 (536870912)
        - NTLMSSP_NEGOTIATE_EXTENDED_SESSIONSECURITY (524288)
        - NTLMSSP_NEGOTIATE_ALWAYS_SIGN (32768)
        - NTLMSSP_NEGOTIATE_NTLM (512)
        - NTLMSSP_NEGOTIATE_SEAL (32)
        - NTLMSSP_NEGOTIATE_SIGN (16)
        - NTLMSSP_REQUEST_TARGET (4)
        - NTLMSSP_NEGOTIATE_OEM (2)
        - NTLMSSP_NEGOTIATE_UNICODE (1)
      DomainNameFields:
        Len: 0
        MaxLen: 0
        BufferOffset: 0
      WorkstationFields:
        Len: 0
        MaxLen: 0
        BufferOffset: 0
      Version:
      Payload:
        DomainName:
        Workstation:
    RawData: 4E544C4D5353500001000000378208E000000000000000000000000000000000
  mechListMIC:
RawData: A12B3029A0030A0101A22204204E544C4D5353500001000000378208E000000000000000000000000000000000
```

```yaml
MessageType: SPNEGO NegTokenResp
Data:
  negState: accept-incomplete (1)
  supportedMech:
  responseToken:
    MessageType: NEGOTIATE_MESSAGE (1)
    Data:
      NegotiateFlags:
        raw: 3758654007
        flags:
        - NTLMSSP_NEGOTIATE_56 (2147483648)
        - NTLMSSP_NEGOTIATE_KEY_EXCH (1073741824)
        - NTLMSSP_NEGOTIATE_128 (536870912)
        - NTLMSSP_NEGOTIATE_EXTENDED_SESSIONSECURITY (524288)
        - NTLMSSP_NEGOTIATE_ALWAYS_SIGN (32768)
        - NTLMSSP_NEGOTIATE_NTLM (512)
        - NTLMSSP_NEGOTIATE_SEAL (32)
        - NTLMSSP_NEGOTIATE_SIGN (16)
        - NTLMSSP_REQUEST_TARGET (4)
        - NTLMSSP_NEGOTIATE_OEM (2)
        - NTLMSSP_NEGOTIATE_UNICODE (1)
      DomainNameFields:
        Len: 0
        MaxLen: 0
        BufferOffset: 0
      WorkstationFields:
        Len: 0
        MaxLen: 0
        BufferOffset: 0
      Version:
      Payload:
        DomainName:
        Workstation:
    RawData: 4E544C4D5353500001000000378208E000000000000000000000000000000000
  mechListMIC:
RawData: A12B3029A0030A0101A22204204E544C4D5353500001000000378208E000000000000000000000000000000000
(ansible-py38) jborean:~/dev/pyspnego$ bin/pyspnego-parse --format yaml --token A181BE3081BBA0030A0101A281B30481B04E544C4D53535000020000001A001A003000000035828AE059961E4FE623221D0000000000000000660066004A0000004A0042004F005200450041004E002D004C0049004E005500580001001A004A0042004F005200450041004E002D004C0049004E00550058000200160057004F0052004B00530054004100540049004F004E0003001A006A0062006F007200650061006E002D006C0069006E0075007800070008002C750671B130D60100000000
MessageType: SPNEGO NegTokenResp
Data:
  negState: accept-incomplete (1)
  supportedMech:
  responseToken:
    MessageType: CHALLENGE_MESSAGE (2)
    Data:
      TargetNameFields:
        Len: 26
        MaxLen: 26
        BufferOffset: 48
      NegotiateFlags:
        raw: 3767173685
        flags:
        - NTLMSSP_NEGOTIATE_56 (2147483648)
        - NTLMSSP_NEGOTIATE_KEY_EXCH (1073741824)
        - NTLMSSP_NEGOTIATE_128 (536870912)
        - NTLMSSP_NEGOTIATE_TARGET_INFO (8388608)
        - NTLMSSP_NEGOTIATE_EXTENDED_SESSIONSECURITY (524288)
        - NTLMSSP_TARGET_TYPE_SERVER (131072)
        - NTLMSSP_NEGOTIATE_ALWAYS_SIGN (32768)
        - NTLMSSP_NEGOTIATE_NTLM (512)
        - NTLMSSP_NEGOTIATE_SEAL (32)
        - NTLMSSP_NEGOTIATE_SIGN (16)
        - NTLMSSP_REQUEST_TARGET (4)
        - NTLMSSP_NEGOTIATE_UNICODE (1)
      ServerChallenge: 59961E4FE623221D
      Reserved: '0000000000000000'
      TargetInfoFields:
        Len: 102
        MaxLen: 102
        BufferOffset: 74
      Version:
      Payload:
        TargetName: JBOREAN-LINUX
        TargetInfo:
        - AvId: MSV_AV_NB_COMPUTER_NAME (1)
          Value: JBOREAN-LINUX
        - AvId: MSV_AV_NB_DOMAIN_NAME (2)
          Value: WORKSTATION
        - AvId: MSV_AV_DNS_COMPUTER_NAME (3)
          Value: jborean-linux
        - AvId: MSV_AV_TIMESTAMP (7)
          Value: '2020-05-23T03:22:51.760158Z'
        - AvId: MSV_AV_EOL (0)
          Value:
    RawData: 4E544C4D53535000020000001A001A003000000035828AE059961E4FE623221D0000000000000000660066004A0000004A0042004F005200450041004E002D004C0049004E005500580001001A004A0042004F005200450041004E002D004C0049004E00550058000200160057004F0052004B00530054004100540049004F004E0003001A006A0062006F007200650061006E002D006C0069006E0075007800070008002C750671B130D60100000000
  mechListMIC:
RawData: A181BE3081BBA0030A0101A281B30481B04E544C4D53535000020000001A001A003000000035828AE059961E4FE623221D0000000000000000660066004A0000004A0042004F005200450041004E002D004C0049004E005500580001001A004A0042004F005200450041004E002D004C0049004E00550058000200160057004F0052004B00530054004100540049004F004E0003001A006A0062006F007200650061006E002D006C0069006E0075007800070008002C750671B130D60100000000
```

```yaml
MessageType: SPNEGO NegTokenResp
Data:
  negState: accept-incomplete (1)
  supportedMech:
  responseToken:
    MessageType: AUTHENTICATE_MESSAGE (3)
    Data:
      LmChallengeResponseFields:
        Len: 0
        MaxLen: 0
        BufferOffset: 80
      NtChallengeResponseFields:
        Len: 216
        MaxLen: 216
        BufferOffset: 80
      DomainNameFields:
        Len: 0
        MaxLen: 0
        BufferOffset: 0
      UserNameFields:
        Len: 54
        MaxLen: 54
        BufferOffset: 296
      WorkstationFields:
        Len: 26
        MaxLen: 26
        BufferOffset: 350
      EncryptedRandomSessionKeyFields:
        Len: 16
        MaxLen: 16
        BufferOffset: 376
      NegotiateFlags:
        raw: 3767173685
        flags:
        - NTLMSSP_NEGOTIATE_56 (2147483648)
        - NTLMSSP_NEGOTIATE_KEY_EXCH (1073741824)
        - NTLMSSP_NEGOTIATE_128 (536870912)
        - NTLMSSP_NEGOTIATE_TARGET_INFO (8388608)
        - NTLMSSP_NEGOTIATE_EXTENDED_SESSIONSECURITY (524288)
        - NTLMSSP_TARGET_TYPE_SERVER (131072)
        - NTLMSSP_NEGOTIATE_ALWAYS_SIGN (32768)
        - NTLMSSP_NEGOTIATE_NTLM (512)
        - NTLMSSP_NEGOTIATE_SEAL (32)
        - NTLMSSP_NEGOTIATE_SIGN (16)
        - NTLMSSP_REQUEST_TARGET (4)
        - NTLMSSP_NEGOTIATE_UNICODE (1)
      Version:
      MIC: 8EFE464238C4F33A354672BE53DB70AE
      Payload:
        LmChallengeResponse:
        NtChallengeResponse:
          ResponseType: NTLMv2
          NTProofStr: 68AE77D2D87A9513FA6E026F75FA5226
          ClientChallenge:
            RespType: 1
            HiRespType: 1
            Reserved1: 0
            Reserved2: 0
            TimeStamp: '2020-05-23T03:22:51.760158Z'
            ChallengeFromClient: DA1DB1AF88A41DF3
            Reserved3: 0
            AvPairs:
            - AvId: MSV_AV_NB_COMPUTER_NAME (1)
              Value: JBOREAN-LINUX
            - AvId: MSV_AV_NB_DOMAIN_NAME (2)
              Value: WORKSTATION
            - AvId: MSV_AV_DNS_COMPUTER_NAME (3)
              Value: jborean-linux
            - AvId: MSV_AV_FLAGS (6)
              Value:
                raw: 2
                flags:
                - MIC_PROVIDED (2)
            - AvId: MSV_AV_TIMESTAMP (7)
              Value: '2020-05-23T03:22:51.760158Z'
            - AvId: MSV_AV_TARGET_NAME (9)
              Value: dc01.domain.local
            - AvId: MSV_AV_CHANNEL_BINDINGS (10)
              Value: '00000000000000000000000000000000'
            - AvId: MSV_AV_EOL (0)
              Value:
            Reserved4: 0
        DomainName:
        UserName: vagrant-domain@DOMAIN.LOCAL
        Workstation: JBOREAN-LINUX
        EncryptedRandomSessionKey: 68E335AE296584950BD8EB8CC4A5055C
      SessionKey: 5A3B00DC0CB9EB28F8DE5411DBE5617B
    RawData: 4E544C4D53535000030000000000000050000000D800D80050000000000000000000000036003600280100001A001A005E010000100010007801000035828AE08EFE464238C4F33A354672BE53DB70AE68AE77D2D87A9513FA6E026F75FA522601010000000000002C750671B130D601DA1DB1AF88A41DF30000000001001A004A0042004F005200450041004E002D004C0049004E00550058000200160057004F0052004B00530054004100540049004F004E0003001A006A0062006F007200650061006E002D006C0069006E00750078000600040002000000070008002C750671B130D6010900220064006300300031002E0064006F006D00610069006E002E006C006F00630061006C000A001000000000000000000000000000000000000000000000000000760061006700720061006E0074002D0064006F006D00610069006E00400044004F004D00410049004E002E004C004F00430041004C004A0042004F005200450041004E002D004C0049004E005500580068E335AE296584950BD8EB8CC4A5055C
  mechListMIC: 01000000B8B7E714154841E200000000
RawData: A18201AD308201A9A0030A0101A282018C048201884E544C4D53535000030000000000000050000000D800D80050000000000000000000000036003600280100001A001A005E010000100010007801000035828AE08EFE464238C4F33A354672BE53DB70AE68AE77D2D87A9513FA6E026F75FA522601010000000000002C750671B130D601DA1DB1AF88A41DF30000000001001A004A0042004F005200450041004E002D004C0049004E00550058000200160057004F0052004B00530054004100540049004F004E0003001A006A0062006F007200650061006E002D006C0069006E00750078000600040002000000070008002C750671B130D6010900220064006300300031002E0064006F006D00610069006E002E006C006F00630061006C000A001000000000000000000000000000000000000000000000000000760061006700720061006E0074002D0064006F006D00610069006E00400044004F004D00410049004E002E004C004F00430041004C004A0042004F005200450041004E002D004C0049004E005500580068E335AE296584950BD8EB8CC4A5055CA312041001000000B8B7E714154841E200000000
```

```yaml
MessageType: SPNEGO NegTokenResp
Data:
  negState: accept-complete (0)
  supportedMech:
  responseToken:
  mechListMIC: 01000000260EC7093B1CCCB900000000
RawData: A11B3019A0030A0100A312041001000000260EC7093B1CCCB900000000
```