# QLogo Utility Scripts and Supporting Files

This directory contains various utility scripts used for generating and maintaining The supporting files for QLogo.

It is not necessary to run these scripts as part of the normal build process. They should only be used when the relevant sources are modified.

The files generated by these scripts are included in the QLogo distribution.

## Scripts

### generate_command_table.py

Generates the header and table files for QLogo primitives from source files. Run this script when any of the relevant executor method signatures are changed or when their command interfaces are changed.

To use, run:

```sh
cd Projects/QLogo
util/generate_command_table.py qlogo/executor include/primitives.h include/workspace/primitivetable.h
```

### generate_help.py

Generates the help text for QLogo commands from source files. Run this script when any of the relevant command help text is changed.

The script takes two arguments: the path to the directory containing the executor source files and the path to the JSON file containing the help text for library routines.

To use, run:

```sh
cd Projects/QLogo
util/generate_help.py qlogo/executor util/logolib_help.json share/qlogo_help.db
```

### generate_library.py

Generates the library files for QLogo from source files. Run this script when any of the relevant library source files are changed.

To use, run:

```sh
cd Projects/QLogo
util/generate_library.py util/logolib.json share/qlogo_library.db
```

### createDesktopIcons.sh

Reads the master desktop icon png file and generates a set of icon files for the QLogo desktop application.

To use, run:

```sh
createDesktopIcons.sh
```

Unlike the other scripts, this file can be run from anywhere. It is not necessary to cd to a specific directory before running it.


## Supporting Files

### logolib_help.json

Contains the help text for QLogo library routines. The script, `generate_help.py`, reads this file and generates the help text SQLite database.

### logolib.json

Contains the library routines for QLogo. The script, `generate_library.py`, reads this file and generates the QLogo library SQLite database.