% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BiocCheckGitClone.R
\name{BiocCheckGitClone}
\alias{BiocCheckGitClone}
\title{Checks specific to a Git clone of a package repository}
\usage{
BiocCheckGitClone(package = ".", ...)
}
\arguments{
\item{package}{A directory containing an R source package. Not a package tar
ball.}

\item{\dots}{Currently, only \code{quit-with-status} is available.  See
\code{BiocCheck}}
}
\value{
\code{BiocCheckGitClone()} is chiefly called for the side effect of the
check reporting. The function returns a \code{BiocCheck} reference class with
three main list elements:

\item{error}{Items to address before the package can be accepted}

\item{warning}{Strongly suggested items that may require attention}

\item{note}{Items to consider, though not required, before acceptance}
}
\description{
Analyzes an R package for adherence with Bioconductor package guidelines and
best practices. The check outputs are categorized into ERROR, WARNING, and
NOTE. This function is typically used in the Bioconductor Build System (BBS)
and not intended for general use.
}
\details{
\code{BiocCheckGitClone()} reviews R packages for adherence with
Bioconductor package guidelines and best practices. See
\url{https://contributions.bioconductor.org} for the latest guidance for
writing Bioconductor software. This function should only be run on a source
directory and not on a tarball.

\code{BiocCheckGitClone} is called within R with, as \preformatted{
BiocCheckGitClone(<package>) } where \code{package} is the source directory
containing the \code{R} package.
}
\examples{

packageDir <- system.file("testpackages", "testpkg0", package="BiocCheck")
BiocCheckGitClone(packageDir, `quit-with-status`=FALSE)

}
\references{
\url{https://contributions.bioconductor.org}
}
\seealso{
\link{BiocCheck-class}
}
\author{
Lori Shepherd
}
