% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tseries-tidiers.R
\name{tidy.garch}
\alias{tidy.garch}
\alias{garch_tidiers}
\title{Tidy a(n) garch object}
\usage{
\method{tidy}{garch}(x, ...)
}
\arguments{
\item{x}{A \code{garch} object returned by \code{\link[tseries:garch]{tseries::garch()}}.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Additionally, if you pass
\code{newdata = my_tibble} to an \code{\link[=augment]{augment()}} method that does not
accept a \code{newdata} argument, it will use the default value for
the \code{data} argument.}
}
\value{
A \link[tibble:tibble]{tibble::tibble} with one row for each coefficient and columns:

\item{term}{The term in the linear model being estimated and tested}
\item{estimate}{The estimated coefficient}
\item{std.error}{The standard error}
\item{statistic}{test statistic}
\item{p.value}{p-value}
}
\description{
Tidy summarizes information about the components of a model.
A model component might be a single term in a regression, a single
hypothesis, a cluster, or a class. Exactly what tidy considers to be a
model component varies cross models but is usually self-evident.
If a model has several distinct types of components, you will need to
specify which components to return.
}
\examples{

library(tseries)

data(EuStockMarkets)
dax <- diff(log(EuStockMarkets))[,"DAX"]
dax.garch <- garch(dax)
dax.garch

tidy(dax.garch)
glance(dax.garch)

}
\seealso{
\code{\link[=tidy]{tidy()}}, \code{\link[tseries:garch]{tseries::garch()}}

Other garch tidiers: 
\code{\link{glance.garch}()}
}
\concept{garch tidiers}
