% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec-result-send-query.R
\docType{data}
\name{spec_result_send_query}
\alias{spec_result_send_query}
\title{spec_result_send_query}
\value{
\code{dbSendQuery()} returns
an S4 object that inherits from \linkS4class{DBIResult}.
The result set can be used with \code{\link[=dbFetch]{dbFetch()}} to extract records.
Once you have finished using a result, make sure to clear it
with \code{\link[=dbClearResult]{dbClearResult()}}.
An error is raised when issuing a query over a closed
or invalid connection,
if the syntax of the query is invalid,
or if the query is not a non-\code{NA} string.
}
\description{
spec_result_send_query
}
\section{Specification}{

No warnings occur under normal conditions.
When done, the DBIResult object must be cleared with a call to
\code{\link[=dbClearResult]{dbClearResult()}}.
Failure to clear the result set leads to a warning
when the connection is closed.

If the backend supports only one open result set per connection,
issuing a second query invalidates an already open result set
and raises a warning.
The newly opened result set is valid
and must be cleared with \code{dbClearResult()}.
}

