% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-geepack.R
\docType{data}
\name{respiratory}
\alias{respiratory}
\alias{respiratoryWide}
\title{Data from a clinical trial comparing two treatments for a respiratory
illness}
\format{
A data frame with 444 observations on the following 8 variables.

\describe{

\item{center}{a numeric vector}
\item{id}{a numeric vector}
\item{treat}{treatment or placebo}
\item{sex}{M or F}
\item{age}{in years at baseline}
\item{baseline}{resporatory status at baseline}
\item{visit}{id of each of four visits}
\item{outcome}{respiratory status at each visit}

}
}
\usage{
respiratory
}
\description{
The data are from a clinical trial of patients with respiratory illness,
where 111 patients from two different clinics were randomized to receive
either placebo or an active treatment. Patients were examined at baseline
and at four visits during treatment. The respiratory
status (categorized as 1 = good, 0 = poor) was determined at each
visit.
}
\examples{

data(respiratory)
data(respiratory, package="geepack")
respiratory$center <- factor(respiratory$center)
head(respiratory)

m1 <- glm(outcome ~ center + treat + age + baseline, data=respiratory,                
          family=binomial())                                                          
gee.ind <- geeglm(outcome ~ center + treat + age + baseline, data=respiratory, id=id, 
          family=binomial(), corstr="independence")                                   
gee.exc <- geeglm(outcome ~ center + treat + age + baseline, data=respiratory, id=id, 
             family=binomial(), corstr="exchangeable")                                
gee.uns <- geeglm(outcome ~ center + treat + age + baseline, data=respiratory, id=id, 
             family=binomial(), corstr="unstructured")                                
gee.ar1 <- geeglm(outcome ~ center + treat + age + baseline, data=respiratory, id=id, 
             family=binomial(), corstr="ar1")                                         

mlist <- list(gee.ind, gee.exc, gee.uns, gee.ar1)
do.call(rbind, lapply(mlist, QIC))
lapply(mlist, tidy)

}
\keyword{datasets}
