% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsearch.R
\name{cart2bary}
\alias{cart2bary}
\title{Conversion of Cartesian to Barycentric coordinates.}
\usage{
cart2bary(X, P)
}
\arguments{
\item{X}{Reference simplex in \eqn{N} dimensions represented by a
\eqn{N+1}-by-\eqn{N} matrix}

\item{P}{\eqn{M}-by-\eqn{N} matrix in which each row is the Cartesian
coordinates of a point.}
}
\value{
\eqn{M}-by-\eqn{N+1} matrix in which each row is the
barycentric coordinates of corresponding row of \code{P}. If the
simplex is degenerate a warning is issued and the function returns
\code{NULL}.
}
\description{
Given the Cartesian coordinates of one or more points, compute
the barycentric coordinates of these points with respect to a
simplex.
}
\details{
Given a reference simplex in \eqn{N} dimensions represented by a
\eqn{N+1}-by-\eqn{N} matrix an arbitrary point \eqn{P} in
Cartesian coordinates, represented by a 1-by-\eqn{N} row vector, can be
written as
\deqn{P = \beta X}
where \eqn{\beta} is an \eqn{N+1} vector of the barycentric coordinates.
A criterion on \eqn{\beta} is that
\deqn{\sum_i\beta_i = 1}
Now partition the simplex into its first \eqn{N} rows \eqn{X_N} and
its \eqn{N+1}th row \eqn{X_{N+1}}. Partition the barycentric
coordinates into the first \eqn{N} columns \eqn{\beta_N} and the
\eqn{N+1}th column \eqn{\beta_{N+1}}. This allows us to write
\deqn{P_{N+1} - X_{N+1} = \beta_N X_N + \beta_{N+1} X_{N+1} - X_{N+1}}
which can be written
\deqn{P_{N+1} - X_{N+1} = \beta_N(X_N - 1_N X_{N+1})}
where \eqn{1_N} is an \eqn{N}-by-1 matrix of ones.  We can then solve
for \eqn{\beta_N}:
\deqn{\beta_N = (P_{N+1} - X_{N+1})(X_N - 1_N X_{N+1})^{-1}}
and compute
\deqn{\beta_{N+1} = 1 - \sum_{i=1}^N\beta_i}
This can be generalised for multiple values of
\eqn{P}, one per row.
}
\note{
Based on the Octave function by David Bateman.
}
\examples{
## Define simplex in 2D (i.e. a triangle)
X <- rbind(c(0, 0),
           c(0, 1),
           c(1, 0))
## Cartesian cooridinates of points
P <- rbind(c(0.5, 0.5),
           c(0.1, 0.8))
## Plot triangle and points
trimesh(rbind(1:3), X)
text(X[,1], X[,2], 1:3) # Label vertices
points(P)
cart2bary(X, P)
}
\seealso{
\code{\link{bary2cart}}
}
\author{
David Sterratt
}
