#' UCLA canonical correlation analysis data
#'
#' This data contains 600 observations on eight variables
#'
#' @details \itemize{
#'   \item locus_of_control - psychological
#'   \item self_concept - psychological
#'   \item motivation - psychological. Converted to four character groups
#'   \item read - academic
#'   \item write - academic
#'   \item math - academic
#'   \item science - academic
#'   \item female - academic. Dropped from original source
#'   \item sex - academic. Added as a character version of female column
#' }
#'
#' @docType data
#' @keywords datasets
#' @name psychademic
#' @usage data(psychademic)
#' @format A data frame with 600 rows and 8 variables
#' @references
#' R Data Analysis Examples | Canonical Correlation Analysis.  UCLA: Institute for Digital Research and Education. from http://www.stats.idre.ucla.edu/r/dae/canonical-correlation-analysis (accessed May 22, 2017).
NULL
