% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glmmTMB.R
\name{fitTMB}
\alias{fitTMB}
\alias{finalizeTMB}
\title{Optimize TMB models and package results, modularly}
\usage{
fitTMB(TMBStruc, doOptim = TRUE)

finalizeTMB(TMBStruc, obj, fit, h = NULL, data.tmb.old = NULL)
}
\arguments{
\item{TMBStruc}{a list containing lots of stuff ...}

\item{doOptim}{logical; do optimization? If FALSE, return TMB object}

\item{obj}{object created by \code{fitTMB(., doOptim = FALSE)}}

\item{fit}{a fitted object returned from \code{nlminb}, or more generally
a similar list (i.e. containing elements \code{par}, \code{objective}, \code{convergence},
\code{message}, \code{iterations}, \code{evaluations})}

\item{h}{Hessian matrix for fit, if computed in previous step}

\item{data.tmb.old}{stored TMB data, if computed in previous step}
}
\description{
These functions (called internally by \code{\link{glmmTMB}}) perform
the actual model optimization, after all of the appropriate structures
have been set up (\code{fitTMB}), and finalize the model after
optimization (\code{finalizeTMB}). It can be useful to run \code{\link{glmmTMB}} with
\code{doFit=FALSE}, adjust the components as required, and then
finish the fitting process with \code{fitTMB} (however, it is the
user's responsibility to make sure that any modifications
create an internally consistent final fitted object).
}
\examples{
## 1. regular (non-modular) model fit:
m0 <- glmmTMB(count ~ mined + (1|site),
             family=poisson, data=Salamanders)
## 2. the equivalent fit, done modularly:
##  a. 
m1 <- glmmTMB(count ~ mined + (1|site),
             family=poisson, data=Salamanders,
             doFit = FALSE)
## result is a list of elements (data to be passed to TMB,
## random effects structures, etc.) needed to fit the model
names(m1)
## b. The next step calls TMB to set up the automatic differentiation
## machinery
m2 <- fitTMB(m1, doOptim = FALSE)
## The result includes initial parameter values, objective function
## (fn), gradient function (gr), etc.
names(m2)
## Optionally, one could choose to 
## modify the components of m1$env$data at this point ...
## updating the TMB structure as follows may be necessary:
m2 <- with(m2$env,
               TMB::MakeADFun(data,
                               parameters,
                               map = map,
                               random = random,
                               silent = silent,
                               DLL = "glmmTMB"))
## c. Use the starting values, objective function, and gradient
## function set up in the previous step to do the nonlinear optimization
m3 <- with(m2, nlminb(par, objective = fn, gr = gr))
## the resulting object contains the fitted parameters, value of
## the objective function, information on convergence, etc.
names(m3)
## d. The last step is to combine the information from the previous
## three steps into a \code{glmmTMB} object that is equivalent to
## the original fit
m4 <- finalizeTMB(m1, m2, m3)
m4$call$doFit <- NULL ## adjust 'call' element to match
all.equal(m0, m4)
}
