% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logging.R
\name{lverbose}
\alias{lverbose}
\alias{lsilent}
\alias{is.verbose}
\alias{lmessage}
\alias{vmessage}
\alias{log_append}
\title{Logging Feature}
\usage{
lverbose(val, global = FALSE)

lsilent()

is.verbose()

lmessage(level, ..., appendLF = TRUE, sep = "", force = FALSE)

vmessage(...)

log_append(...)
}
\arguments{
\item{val}{logical/numeric value that sets the verbosity level.}

\item{global}{logical that indicates if the verbose level of
all log handlers should be set to \var{val}.}

\item{level}{verbosity level threshold (numeric value) above which the
message should be printed out.
This threshold is compared with the current verbosity level as returned by
\code{lverbose}.}

\item{...}{parts of a character message that are concatenated and passed to
the current logger's write function.}

\item{appendLF}{logical indicating if an endline character should be appended
at the end of the message.}

\item{sep}{separation character, used when concatenating all arguments in \code{...}.}

\item{force}{logical that indicates if one should output messages or return a non
null logger, even if the verbose mode is not high enough.}
}
\value{
the old verbose level
}
\description{
\code{lverbose} returns/sets the current verbosity level.
}
\section{Functions}{
\itemize{
\item \code{lsilent}: tells if all verbose messages are silenced.

\item \code{is.verbose}: tells if verbosity is on, i.e. at level greater than 0.

\item \code{lmessage}: prints out a message (on sdtout) if the verbosity level is greater than a
given value.

\item \code{vmessage}: prints out a log message (at level 1) using the current logger,
typically on stdout.
It is a shortcut for \code{lmessage(1L, ...)}.

\item \code{log_append}: directly appends some message to the current log line.
}}

