% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/each.r
\name{each}
\alias{each}
\title{Aggregate multiple functions into a single function.}
\usage{
each(...)
}
\arguments{
\item{...}{functions to combine. each function should produce a single
number as output}
}
\description{
Combine multiple functions into a single function returning a named vector
of outputs.
Note: you cannot supply additional parameters for the summary functions
}
\examples{
# Call min() and max() on the vector 1:10
each(min, max)(1:10)
# This syntax looks a little different.  It is shorthand for the
# the following:
f<- each(min, max)
f(1:10)
# Three equivalent ways to call min() and max() on the vector 1:10
each("min", "max")(1:10)
each(c("min", "max"))(1:10)
each(c(min, max))(1:10)
# Call length(), min() and max() on a random normal vector
each(length, mean, var)(rnorm(100))
}
\seealso{
\code{\link{summarise}} for applying summary functions to data
}
\keyword{manip}

