% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{step_filter}
\alias{step_filter}
\title{Filter rows using dplyr}
\usage{
step_filter(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  inputs = NULL,
  skip = TRUE,
  id = rand_id("filter")
)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{Logical predicates defined in terms of the variables
in the data. Multiple conditions are combined with \code{&}. Only
rows where the condition evaluates to \code{TRUE} are kept. See
\code{\link[dplyr:filter]{dplyr::filter()}} for more details.}

\item{role}{Not used by this step since no new variables are
created.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{inputs}{Quosure of values given by \code{...}.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[=bake]{bake()}}? While all operations are baked
when \code{\link[=prep]{prep()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = FALSE}.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An updated version of \code{recipe} with the new step added to the
sequence of any existing operations.
}
\description{
\code{step_filter()} creates a \emph{specification} of a recipe step that will remove
rows using \code{\link[dplyr:filter]{dplyr::filter()}}.
}
\details{
When an object in the user's global environment is
referenced in the expression defining the new variable(s),
it is a good idea to use quasiquotation (e.g. \verb{!!}) to embed
the value of the object in the expression (to be portable
between sessions). See the examples.
}
\section{Row Filtering}{


This step can entirely remove observations (rows of data), which can have
unintended and/or problematic consequences when applying the step to new
data later via \code{\link[=bake]{bake()}}. Consider whether \code{skip = TRUE} or
\code{skip = FALSE} is more appropriate in any given use case. In most instances
that affect the rows of the data being predicted, this step probably should
not be applied at all; instead, execute operations like this outside and
before starting a preprocessing \code{\link[=recipe]{recipe()}}.
}

\section{Tidying}{
When you \code{\link[=tidy.recipe]{tidy()}} this step, a tibble is returned with
columns \code{terms} and \code{id}:

\describe{
\item{terms}{character, the selectors or variables selected}
\item{id}{character, id of this step}
}

The expressions in \code{terms} are text representations and are not parsable.
}

\section{Case weights}{


The underlying operation does not allow for case weights.
}

\examples{
rec <- recipe(~., data = iris) \%>\%
  step_filter(Sepal.Length > 4.5, Species == "setosa")

prepped <- prep(rec, training = iris \%>\% slice(1:75))

library(dplyr)

dplyr_train <-
  iris \%>\%
  as_tibble() \%>\%
  slice(1:75) \%>\%
  dplyr::filter(Sepal.Length > 4.5, Species == "setosa")

rec_train <- bake(prepped, new_data = NULL)
all.equal(dplyr_train, rec_train)

dplyr_test <-
  iris \%>\%
  as_tibble() \%>\%
  slice(76:150) \%>\%
  dplyr::filter(Sepal.Length > 4.5, Species != "setosa")
rec_test <- bake(prepped, iris \%>\% slice(76:150))
all.equal(dplyr_test, rec_test)

values <- c("versicolor", "virginica")

qq_rec <-
  recipe(~., data = iris) \%>\%
  # Embed the `values` object in the call using !!
  step_filter(Sepal.Length > 4.5, Species \%in\% !!values)

tidy(qq_rec, number = 1)
}
\seealso{
Other row operation steps: 
\code{\link{step_arrange}()},
\code{\link{step_impute_roll}()},
\code{\link{step_lag}()},
\code{\link{step_naomit}()},
\code{\link{step_sample}()},
\code{\link{step_shuffle}()},
\code{\link{step_slice}()}

Other dplyr steps: 
\code{\link{step_arrange}()},
\code{\link{step_mutate_at}()},
\code{\link{step_mutate}()},
\code{\link{step_rename_at}()},
\code{\link{step_rename}()},
\code{\link{step_sample}()},
\code{\link{step_select}()},
\code{\link{step_slice}()}
}
\concept{dplyr steps}
\concept{row operation steps}
