% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geodist.R
\name{step_geodist}
\alias{step_geodist}
\title{Distance between two locations}
\usage{
step_geodist(
  recipe,
  lat = NULL,
  lon = NULL,
  role = "predictor",
  trained = FALSE,
  ref_lat = NULL,
  ref_lon = NULL,
  is_lat_lon = TRUE,
  log = FALSE,
  name = "geo_dist",
  columns = NULL,
  keep_original_cols = TRUE,
  skip = FALSE,
  id = rand_id("geodist")
)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{lon, lat}{Selector functions to choose which variables are
used by the step. See \code{\link[=selections]{selections()}} for more details.}

\item{role}{For model terms created by this step, what analysis role should
they be assigned? By default, the new columns created by this step from
the original variables will be used as \emph{predictors} in a model.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{ref_lon, ref_lat}{Single numeric values for the location
of the reference point.}

\item{is_lat_lon}{A logical: Are coordinates in latitude and longitude? If
\code{TRUE} the Haversine formula is used and the returned result is meters. If
\code{FALSE} the Pythagorean formula is used. Default is \code{TRUE} and for recipes
created from previous versions of recipes, a value of \code{FALSE} is used.}

\item{log}{A logical: should the distance be transformed by
the natural log function?}

\item{name}{A single character value to use for the new
predictor column. If a column exists with this name, an error is
issued.}

\item{columns}{A character string of the selected variable names. This field
is a placeholder and will be populated once \code{\link[=prep]{prep()}} is used.}

\item{keep_original_cols}{A logical to keep the original variables in the
output. Defaults to \code{FALSE}.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[=bake]{bake()}}? While all operations are baked
when \code{\link[=prep]{prep()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An updated version of \code{recipe} with the new step added to the
sequence of any existing operations.
}
\description{
\code{step_geodist()} creates a \emph{specification} of a recipe step that will
calculate the distance between points on a map to a reference location.
}
\details{
\code{step_geodist} uses the Pythagorean theorem to calculate Euclidean
distances if \code{is_lat_lon} is FALSE. If \code{is_lat_lon} is TRUE, the Haversine
formula is used to calculate the great-circle distance in meters.
}
\section{Tidying}{
When you \code{\link[=tidy.recipe]{tidy()}} this step, a tibble is returned with
columns \code{latitude}, \code{longitude}, \code{ref_latitude}, \code{ref_longitude},
\code{is_lat_lon}, \code{name} , and \code{id}:

\describe{
\item{latitude}{character, name of latitude variable}
\item{longitude}{character, name of longitude variable}
\item{ref_latitude}{numeric, location of latitude reference point}
\item{ref_longitude}{numeric, location of longitude reference point}
\item{is_lat_lon}{character, the summary function name}
\item{name}{character, name of resulting variable}
\item{id}{character, id of this step}
}
}

\section{Case weights}{


The underlying operation does not allow for case weights.
}

\examples{
\dontshow{if (rlang::is_installed("modeldata")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data(Smithsonian, package = "modeldata")

# How close are the museums to Union Station?
near_station <- recipe(~., data = Smithsonian) \%>\%
  update_role(name, new_role = "location") \%>\%
  step_geodist(
    lat = latitude, lon = longitude, log = FALSE,
    ref_lat = 38.8986312, ref_lon = -77.0062457,
    is_lat_lon = TRUE
  ) \%>\%
  prep(training = Smithsonian)

bake(near_station, new_data = NULL) \%>\%
  arrange(geo_dist)

tidy(near_station, number = 1)
\dontshow{\}) # examplesIf}
}
\references{
https://en.wikipedia.org/wiki/Haversine_formula
}
\seealso{
Other multivariate transformation steps: 
\code{\link{step_classdist_shrunken}()},
\code{\link{step_classdist}()},
\code{\link{step_depth}()},
\code{\link{step_ica}()},
\code{\link{step_isomap}()},
\code{\link{step_kpca_poly}()},
\code{\link{step_kpca_rbf}()},
\code{\link{step_kpca}()},
\code{\link{step_mutate_at}()},
\code{\link{step_nnmf_sparse}()},
\code{\link{step_nnmf}()},
\code{\link{step_pca}()},
\code{\link{step_pls}()},
\code{\link{step_ratio}()},
\code{\link{step_spatialsign}()}
}
\concept{multivariate transformation steps}
