% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/env.R
\name{env_print}
\alias{env_print}
\title{Pretty-print an environment}
\usage{
env_print(env = caller_env())
}
\arguments{
\item{env}{An environment, or object that can be converted to an
environment by \code{\link[=get_env]{get_env()}}.}
}
\description{
This prints:
\itemize{
\item The \link[=env_label]{label} and the parent label.
\item Whether the environment is \link[=env_lock]{locked}.
\item The bindings in the environment (up to 20 bindings). They are
printed succintly using \code{pillar::type_sum()} (if available,
otherwise uses an internal version of that generic). In addition
\link[=env_bind_lazy]{fancy bindings} (actives and promises) are
indicated as such.
\item Locked bindings get a \verb{[L]} tag
}
}
