# Announce: Rakudo Perl 6 compiler, Release #112 (2017.06)

On behalf of the Rakudo development team, I’m very happy to announce the
June 2017 release of Rakudo Perl 6 #112. Rakudo is an implementation of
Perl 6 on the Moar Virtual Machine[^1].

This release implements the 6.c version of the Perl 6 specifications.
It includes bugfixes and optimizations on top of
the 2015.12 release of Rakudo, but no new features.

Upcoming releases in 2017 will include new functionality that is not
part of the 6.c specification, available with a lexically scoped
pragma. Our goal is to ensure that anything that is tested as part of the
6.c specification will continue to work unchanged. There may be incremental
spec releases this year as well.

The tarball for this release is available from <http://rakudo.org/downloads/rakudo/>.

Please note: This announcement is not for the Rakudo Star
distribution[^2] --- it’s announcing a new release of the compiler
only. For the latest Rakudo Star release, see
<http://rakudo.org/downloads/star/>.

The changes in this release are outlined below:

New in 2017.06:
 + Fixes:
    + Fixed incorrect auto-boxing to native candidates in multi dispatch [ccfa5e51]
    + `^Inf .elems` now fails instead of returning Inf [20310d7d]
    + Made IO::Handle.print/.put signature consistent [613bdcf8]
    + Made sure that Setty:U is treated like any type object [ad8fa552]
    + Fixed behaviour of set() `(<)` X.Set [e6506bfd]
    + Made sure VM.osname always returns lowercase string [122aca1c]
    + Fixed List.Capture with non-Str-key Pairs [5b25836f]
    + Fixed inconsistency in .Int on zero-denominator Rats [6dbe85ed]
    + Fixed crash in smartmatch of non-Numerics with Numeric [43b03fc6]
    + Fixed occasional Windows file permission issues with installation of modules [8ec4dc5b]
    + Fixed crash in `X` operator used with empty List [9494cbd3]
    + Fixed spurious warnings/crash with certain `=para` Pod blocks [5e339345][807d30c2]
    + Fixed output of `CArray[Pointer].^shortname` [1ed284e2]
    + Fixed crash in Test.pm6's bail-out when used before tests [cb827606]
    + Fixed object Hash -> Set coercion failing to consider values [160de7e6]
    + Fixed Seq.perl for containerized Seqs [b22383fe]
    + Fixed Proc::Async.new not slurping first positional [92c187d2]
    + Fixed Proc::Async.kill failing to kill sometimes [99421d4c]
    + Fixed hang in deepmap with Iterable type objects [252dbf3a]
    + Fixed crash when Junctioning empty array after .elems'ing it [aa368421]
    + Fixed crashes/LTA errors in Junction.new w/wrong args [61ecfd51]
    + Fixed `infix:<orelse>` calling .defined one too many times [77d3c546]
    + Made `fail` re-arm handled Failures given as arguments [64e898f9]
    + Fixed output of IO::Special.perl [7344a3d2]
    + Made IO::Handle.open with path '-'.IO properly handle non-default `$*OUT`/`$*ERR` [3755c0e7]
    + Fixed Promise.then to not lose dynamic variables [36bc4102]
    + Fixed allomorph smartmatching with Str values [8a0b7460]
    + Fixed IO::Path.extension with Range `:parts` when endpoints were excluded [8efffb1d]
    + Made coercion of lazy Iterable to Setty fail [211063c7]
    + Made Mixy/Baggy.new-from-pairs with a lazy Iterable fail [c9dfa840][e5719d6a]
    + Fixed byte.Range returning an incorrect range [af85d538]
    + Fixed edge-cases (e.g. Nan/Inf) in Mixy.roll [fb9e1a87]
    + Made sure that Mixy types only take Real values [7fa85682]
    + Fixed incorrect results in ignorecase+ignoremark regex matches [1ac7996a]
    + Fixed issues with `$*CWD` inside &indir when using relative paths [9151ebaa][326faed6]
    + Fixed crash with Seq:U.List [5c56e9e7]
    + Fixed various issues with Map `(<=)` Map [e1563a76]
    + Fixed various issues with Map `(<)` Map [b03d8044]
    + Fixed 4 cases of crashes with labeled `next` [3b67b4ac]
    + Made Proc.status/Numeric/Bool/exitcode/sink wait for Proc to be done [e4468c61]
    + Fixed Pair.perl with type-object components [c6b03c45]
    + Fixed bad shell quoting in Proc::Async on Windows [e9b30933]
    + Fixed crash when RAKUDO_MODULE_DEBUG was set to a non-numeric value [96e6b338]
    + Fixed Kernel.signals on OpenBSD [9435c14e]
    + Various improvements to warnings and error reporting [1c16bf2e][85bef661][e22508d4]
        [b6694bd0][ec51e73f][f2fca0c8][f9403b3b][86fe766a][c81b7a4b][7cf01296][fb7dd8a4]
        [7783fcab][9bf3ea3a][02614f64][e538cbc5][86c3d7aa][c2497234][b0a1b6c3][97298aca]
        [69b1b6c8][5e037736][e824266f]
 + Additions:
    + Implemented IO::CatHandle [5227828a]
    + Implemented support for merged STDOUT/ERR output Proc and Proc::Async [ac31c5df][05d8b883]
    + Implemented Complex.cis [a243063c]
    + Implemented Failure.self [0a100825]
    + Implemented Any.Seq [5c56e9e7]
    + Improved consistently to have .Supply on a type object it as Supply [52d39576]
    + Slightly changed IO::Handle.encoding; Nil now means 'bin'
        [95b4e5d5][27f09e9d][9c0362cb][51c73ba0]
    + Gave `(<=)` Baggy and Mixy semantics for Bags/Mixes [b1d83f9d]
    + Makde `use lib` accept IO::Path objects [3ff29d42]
    + Added IO::Socket.nl-out attribute [12d31e36]
    + Added Setty.pickpairs [e3695b16]
    + Added Str type constraints to IO::Spec::Win32 .join and .catpath [232cf190]
    + Made it possible to call &prompt with no args [0646d3fa]
    + Made IO::Socket::INET update localport if it binds on port 0 [bc98e671]
    + Improved support for Unicode properties `Prepend` and `Regional Indicator` [56e71d59]
    + Gave IO::Handle.read default value for size arg [b7150ae1][aa9516be]
    + Added default output for Mu.WHY [23d6d42d][cc4d9091]
    + Added support for binding to standard handles in Proc::Async [6b2967d7]
    + [JVM] Implemented Proc::Async [5154b620]
 + Removals:
    + Removed TAP.pm6 from core. Available as `TAP::Harness` in the ecosystem [ae891f93]
    + Removed all methods from IO::ArgFiles and made it a subclass of IO::CatHandle [f539a624]
    + Removed IO::Socket::INET.ins [75693b0b]
    + Removed NYI IO::Socket.poll method [cb404c43]
 + Efficiency:
    + Made Any (elem) Iterable:D between 1.3x and 110x faster [e65800a8]
    + Made `(<=)` and `(>=)` about 50x faster [32eb285f]
    + Made IO::Spec::Win32.catpath 47x faster [7d6fa739]
    + Made `(<)` and `(>)` about 40x faster [431ed4e3]
    + Made IO::Spec::Win32.join 26x faster [494659a1]
    + Made IO::Spec::Win32.splitdir 25x faster [2816ef71]
    + Made Map `(<=)` Map about 15x faster [0cb4df44]
    + Made Map `(<)` Map about 15x faster [f6f54dcf]
    + Made Str.subst(Str) without :g 14x faster [0331fb9d]
    + Made Setty.roll about 11x faster [e6192ca8]
    + Made IO::Spec::Unix.splitdir 7.7x faster [6ca702fa]
    + Made invocation of Proc.spawn and &run 4.6x faster [93524fb9]
    + Made SetHash.grab(N) about 3.5x faster [67292a1e]
    + Made SetHash.grabpairs(N) about 3.5x faster [0e9ee0d1]
    + Made invocation of Blob.decode() 2.7x faster [222b4083]
    + Made Baggy/Mixy.(hash|Hash) about 2.5x as fast (on a 26 elem Bag/Mix) [06cd0bc3]
    + Made Setty.roll(N) about 2x faster [18dd0741]
    + Made Setty.pick about 2x faster [10e9c8ba]
    + Made Set.new(@a) about 2x faster [b55a0f16]
    + Made Baggy.new(@a) about 2x faster [11f27a30]
    + Made SetHash.grab about 1.8x faster [d28540be]
    + Made Str:D (elem) Map:D 1.3x faster [b43303f2]
    + Made `$*KERNEL.signal` 64% faster, overall [79b8ab9d][01d948d2]
    + Made Iterable.Bag about 60% faster [f2876281]
    + Made Iterable.Mix(|Hash) about 40% faster [bba6de5f]
    + Made Setty.pick(N) about 30% faster [071c88cb]
    + Made StrDistance 25% faster [2e041b06][9185fa2c]
    + Made (Bag|Mix).AT-KEY about 10% faster [b43db636]
    + Made `infix:<∉>` about 10% faster [abfb52be]
    + Made Str.starts-with 8% faster [7ecb59dc]
    + Made .Set, .Bag, and .Mix coercers a few percent faster [8791b447][4139b96e][8c7e4e51]
    + Fixed lost optimization of for ^N {}; now its 3x faster [46b11f54]
    + Made &DYNAMIC about 1% faster [74242e55]
    + Made ^Inf marginally faster [446dc190]
    + Assorted internal improvements to CPU/memory use [2efd812c][07bff0e5][1369632f][2ac120ce]
        [539415cf][5ebf307a][ed07b2c3][0104a439][a91a2e4d][bd292225][8ff980e7][7edf9da6][241d2925]
        [7e8bac9b][3363c7b9][6f932687][e9b30933][51b63bf9][57553386][1171e67e]
 + Internal:
    + Refactored handle encoding. Non-binary read methods now throw when used
        on handles in binary mode [41bb1372][b3cd299e]
    + Refactored socket encoding [8ee383e3]
    + Made syncronous IO to not use libuv [05f3e9a0]
    + Made syncronous sockets to not use libuv [6f202fbe]
    + Moved encoding and line ending bits to IO::Socket [d6fd2491]
    + Moved get and lines to IO::Socket role [9cec9408]
    + IO::Path.Int method removed; handled by Cool.Int now [d13d9c2e]
    + Re-implemented Proc in terms of Proc::Async [ac31c5df]


The following people contributed to this release:

Elizabeth Mattijsen, Jonathan Worthington, Pawel Murias, Jan-Olof Hendig, 
Samantha McVey, Christian Bartolomäus, Daniel Green, Tom Browder, cono, 
Will "Coke" Coleda, Stefan Seifert, Antonio Quinonez, Nick Logan, 
Dan Miller, Steve Mynott, JJ Merelo, Lloyd Fournier, 
Juan Julián Merelo Guervós, Gabor Szabo, Trey Harris, Eckhart Arnold, 
Julien Simonet, Moritz Lenz, Timo Paulssen, flussence, raiph, Kris Shannon, 
Aleks-Daniel Jakimenko-Aleksejev, Fyodor Sizov, Zoffix Znet

If you would like to contribute or find out more information, visit
<http://perl6.org>, <http://rakudo.org/how-to-help>, ask on the
<perl6-compiler@perl.org> mailing list, or ask on IRC #perl6 on freenode.

Additionally, we invite you to make a donation to The Perl Foundation
to sponsor Perl 6 development: <https://donate.perlfoundation.org/>
(put "Perl 6 Core Development Fund" in the 'Purpose' text field)

The next release of Rakudo (#113), is tentatively scheduled for 2017-07-15.

A list of the other planned release dates is available in the
“docs/release_guide.pod” file.

The development team appreciates feedback! If you’re using Rakudo, do
get back to us. Questions, comments, suggestions for improvements, cool
discoveries, incredible hacks, or any other feedback -- get in touch with
us through (the above-mentioned) mailing list or IRC channel. Enjoy!

Please note that recent releases have known issues running on the JVM.
We are working to get the JVM backend working again but do not yet have
an estimated delivery date.

[^1]: See <http://moarvm.org/>

[^2]: What’s the difference between the Rakudo compiler and the Rakudo
Star distribution?

The Rakudo compiler is a compiler for the Perl 6 language.
Not much more.

The Rakudo Star distribution is the Rakudo compiler plus a selection
of useful Perl 6 modules, a module installer, Perl 6 introductory documentation, 
and other software that can be used with the Rakudo compiler to enhance its utility.

