#ifndef _RHEOBASE_H
#define _RHEOBASE_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================
//
// basic include file for skit implementation
//

# include "rheolef/config.h"   /* system dependant includes and defines */
# include "rheolef/skitbase.h"      /* compiler dependant includes */
namespace rheolef { 
//
// ANSI C++ requires:
//   void vector<T>::resize(size_type sz, T c = T());
// GNU C++ old-version has not...
//
template <class T>
static inline
void 
resize (
    std::vector<T> &     xx, 
    size_t               n,
    const T&             init_value)
{
    if (n > xx.size ())
       xx.insert (xx.end (), n-xx.size (), init_value);
    else if (n < xx.size ())
       xx.erase (xx.begin ()+n, xx.end ());
}
}// namespace rheolef
#endif // _RHEOBASE_H
