#!/usr/bin/env python
#
# This file is part of Rheolef.
#
# Copyright (C) 2000-2009 Pierre Saramito 
#
# Rheolef is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Rheolef is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Rheolef; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# --------------------------------------------------------------------------
#
# mayavi/python script for the visualization of fields
#
# author ; Pierre.Saramito@imag.fr
#
# date : 24 january 2006
#
# TODO:
#	- set main label font & size
#	- del Z axis and set label font & size
#
import mayavi
import vtk

# utility
def mayavi_field_show_lut (v, label=''):
  dvm = v.mayavi.data_viz_mgr[v.mayavi.cur_dvm_name]
  mm  = dvm.get_current_module_mgr ()
  lut = mm.scalar_lut_h
  lut.legend_on.set(1)
  lut.label_var.set (label)
  lut.legend_on_off()		# refresh on_off and label
  lut.set_label()

def opacity_transfer_function(x1, x2):
    maxs = max(x1, x2)
    mins = min(x1, x2)
    ds=(maxs - mins)/4.0
    opacityTransferFunction = vtk.vtkPiecewiseFunction()
    opacityTransferFunction.AddPoint(mins,      0.00)
    opacityTransferFunction.AddPoint(mins+1*ds, 0.15)
    opacityTransferFunction.AddPoint(mins+2*ds, 0.30)
    opacityTransferFunction.AddPoint(mins+3*ds, 0.75)
    opacityTransferFunction.AddPoint(maxs,      1.00)
    return opacityTransferFunction

def color_transfer_function(x1, x2):
    maxs = max(x1, x2)
    mins = min(x1, x2)
    ds=(maxs - mins)/4.0
    colorTransferFunction = vtk.vtkColorTransferFunction()
    colorTransferFunction.AddRGBPoint(mins,      0.00, 0.0, 0.00)
    colorTransferFunction.AddRGBPoint(mins+ds,   0.00, 0.0, 0.25)
    colorTransferFunction.AddRGBPoint(mins+2*ds, 0.00, 0.0, 0.50)
    colorTransferFunction.AddRGBPoint(mins+3*ds, 0.00, 0.0, 0.75)
    colorTransferFunction.AddRGBPoint(maxs,      1.00, 1.0, 1.00)
    return colorTransferFunction

def mayavi_field_scalar(v, basename, option):

  data = v.open_vtk (basename+".vtk", config=0)
  outline = v.load_module ('Outline', config=0)
  if option['view_2d']:
    v.renwin.z_plus_view()
  axes    = v.load_module ('Axes', config=0)
  if not option['volume']:
    mayavi_field_show_lut (v, option['label'])
  if option['view_2d']:
    vector  = v.load_module ('SurfaceMap', config=0)
    if not option['fill']:
      vector.actor.GetProperty().SetRepresentationToWireframe()
  else:
    if option['volume']:
      filter  = v.load_filter ('StructuredPointsProbe', config=0)
      volume  = v.load_module ('Volume', config=0)
      volume.map_type_var.set(1)
      volume.change_map_type_gui()	# refresh view
      range = volume.data_range
      vol_prop = volume.actor.GetProperty ()
      vol_prop.SetColor(color_transfer_function(range[0], range[1]))
      vol_prop.SetScalarOpacity(opacity_transfer_function(range[0], range[1]))
    if option['cut']:
      cut  = v.load_module ('ScalarCutPlane', config=0)
    if option['iso'] or not (option['volume'] or option['cut']):
      iso  = v.load_module ('IsoSurface', config=0)

def mayavi_field_deformation(v, basename, option):

  vtk_name = basename + ".vtk"
  data    = v.open_vtk(vtk_name, config=0)
  axes    = v.load_module ('Axes', config=0)
  outline = v.load_module ('Outline', config=0)

  if option['grid']:
     grid    = v.load_module ('SurfaceMap', config=0)
     grid.actor.GetProperty().SetColor(0.8, 0.8, 0.8)
     grid.actor.GetProperty().SetRepresentationToWireframe()
     grid.map.ScalarVisibilityOff ()
     # reload data : translate and map colors mapping using vector norm
 
  data    = v.open_vtk(vtk_name, config=0)
  translate_filter = v.load_filter('WarpVector', 0)
  translate_filter.fil.SetScaleFactor(option['scale'])
  vect_norm_filter = v.load_filter('ExtractVectorNorm', 0)
  translated_mesh  = v.load_module ('SurfaceMap', config=0)
  if not option['fill']:
    translated_mesh.actor.GetProperty().SetRepresentationToWireframe()
  mayavi_field_show_lut(v, option['label'])
  if option['view_2d']:
    v.renwin.z_plus_view()

def mayavi_field_velocity(v, basename, option):

  data = v.open_vtk (basename+".vtk", config=0)
  mayavi_field_show_lut (v, option['label'])
  axes    = v.load_module ('Axes', config=0)
  outline = v.load_module ('Outline', config=0)
  vector  = v.load_module ('VelocityVector', config=0)
  vector.glyph2d_src.SetCenter (0, 0, 0)
  vector.glyph2d_src.SetScale (option['scale'])
  if option['view_2d']:
     v.renwin.z_plus_view()

def mayavi_field_vector(v, basename, option):

  if option['style'] == 'deformation':
    mayavi_field_deformation(v, basename, option)
  else:
    mayavi_field_velocity(v, basename, option)

def mayavi_field_tensor(v, basename, option):

  data = v.open_vtk (basename+".vtk", config=0)
  mayavi_field_show_lut (v, option['label'])
  axes    = v.load_module ('Axes', config=0)
  outline = v.load_module ('Outline', config=0)
  tensor  = v.load_module ('TensorGlyphs', config=0)
# tensor.glyphs.SetCenter (0, 0, 0)
  tensor.glyphs.SetScaleFactor (option['scale'])
  if option['view_2d']:
     v.renwin.z_plus_view()

