///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
// 
// This code presents sparse vector expressions
// 
// also print matlab code for non-regression test purpose, i.e.
//
// usage: sblas1 -check | octave
//
# include "rheolef/skit.h"
using namespace rheolef;
using namespace std;

bool do_check;

void check (const avec<Float>& y, const char* expr)
{
    if (!do_check) return;

    static int i = 0;
    cout << "y=" << expr    << ";\n";
    cout << "z=" << ml << y << ";\n";
    
    cout << "error" << ++i << "=norm(y-z)\n\n";
}
int main (int argc, char* argv[])
{
warning_macro("he[1]");

    do_check = (argc > 1);
    if (do_check) {
warning_macro("he[1]: check...");
    }

    const unsigned int n = 10;

    // initialize with a constant: FIRST allocation
        
warning_macro("he[2]");
	avec<Float> x1(n);
warning_macro("he[3]");
        x1.entry(0) = 1;
warning_macro("he[4]");
        x1.entry(2) = 1;
warning_macro("he[5]");
        x1.entry(4) = 1;
        x1.entry(5) = 1;
        x1.entry(7) = 1;
        x1.entry(9) = 1;
        
warning_macro("he[6]");
	avec<Float> x2(n);
        x2.entry(3) = 1;
        x2.entry(5) = 1;
        x2.entry(6) = 1;
        x2.entry(7) = 1;
        
warning_macro("he[7]");
	if (do_check) {
	    cout << "x1=" << ml << x1 << ";" << endl;
	    cout << "x2=" << ml << x2 << ";" << endl;
	}
    // shallow copy: y points to x, really
warning_macro("he[8]");
        avec<Float> y = x1;
        check (y, "x1");

    // unary operator
warning_macro("he[9]");
        y = -x1;
        check (y, "-x1");
    
    // addition, substraction
warning_macro("he[10]");
        y = x1+x2;
warning_macro("he[11]");
        check (y, "x1+x2");
        
warning_macro("he[12]");
	y = x1-x2;
warning_macro("he[13]");
        check (y, "x1-x2");
warning_macro("he[14]");
#ifdef TODO
    // scalar-avec mixtes expressions: loop enrolled...
	y = 2*x - (x*x)*3;
        check (y, "2*x - 3*(x.*x)");

    // computed assignment
	y *= 2;
        check (y, "2*y");
        
	y /= 2;
        check (y, "y/2");
        
	y += 2*x;
        check (y, "y+2*x");
    
	y -= 2*x;
        check (y, "y-2*x");
    
    // function call
	y = sin(x);
        check (y, "sin(x)");

    // avec appears in left and right hand
        y = -y;
        check (y, "-y");
#endif // TODO

    // epilogue:
warning_macro("he[15]");
	if (do_check) return(0);
	cout << "count_cumul        =" << count_cumul       << endl
	     << "count_max_current  =" << count_max_current << endl;
warning_macro("he[16]");
	return(0);
}
