= Event
* ((<Event system Overview>))
* ((<SDL::Event>))
* ((<SDL::Event::Active>))
* ((<SDL::Event::KeyDown>))
* ((<SDL::Event::KeyUp>))
* ((<SDL::Event::MouseMotion>))
* ((<SDL::Event::MouseButtonDown>))
* ((<SDL::Event::MouseButtonUp>))
* ((<SDL::Event::JoyAxis>))
* ((<SDL::Event::JoyBall>))
* ((<SDL::Event::JoyHat>))
* ((<SDL::Event::JoyButtonDown>))
* ((<SDL::Event::JoyButtonUp>))
* ((<SDL::Event::Quit>))
* ((<SDL::Event::SysWM>))
* ((<SDL::Event::VideoResize>))
* ((<SDL::Event::VideoExpose>))
* ((<SDL::Key>))
* ((<SDL::Mouse>))
* Methdos for Event
  * ((<SDL::Event.poll>)) -- Polls for currently pending events.
  * ((<SDL::Event.wait>)) -- Waits indefinitely for the next available event.
  * ((<SDL::Event.push>)) -- Pushes an event onto the event queue.
  * ((<SDL::Event.app_state>)) -- Get the state of the application.
  * ((<SDL::Event.enable_unicode>)) -- Enable UNICODE translation
  * ((<SDL::Event.disable_unicode>)) -- Disable UNICODE translation
  * ((<SDL::Event.enable_unicode?>)) -- Get whether UNICODE translation is enabled.
  * ((<SDL::Event::Active#gain>)) -- Returns whether gaining visibility or not
  * ((<SDL::Event::Active#state>)) -- Gets the type of visibility event.
  * ((<SDL::Event::KeyDown#press>)) -- Returns true.
  * ((<SDL::Event::KeyDown#sym>)) -- Get the key symbol of pressed key
  * ((<SDL::Event::KeyDown#mod>)) -- Current key modifier
  * ((<SDL::Event::KeyDown#unicode>)) -- Translated character
  * ((<SDL::Event::KeyUp#press>)) -- Whether key is pressed
  * ((<SDL::Event::KeyUp#sym>)) -- Get the key symbol of released key
  * ((<SDL::Event::KeyUp#mod>)) -- Current key modifier
  * ((<SDL::Event::MouseMotion#state>)) -- The current button state
  * ((<SDL::Event::MouseMotion#x>)) -- The X coordinate of the mouse
  * ((<SDL::Event::MouseMotion#y>)) -- the X coordinate of the mouse.
  * ((<SDL::Event::MouseMotion#xrel>)) -- Relative motion in the X direction
  * ((<SDL::Event::MouseMotion#yrel>)) -- Relative motion in the Y direction
  * ((<SDL::Event::MouseButtonDown#button>)) -- The mouse button index
  * ((<SDL::Event::MouseButtonDown#press>)) -- Whether mouse button is pressed or not
  * ((<SDL::Event::MouseButtonDown#x>)) -- The X coordinate of the mouse at press time.
  * ((<SDL::Event::MouseButtonDown#y>)) -- The Y coordinate of the mouse at press time
  * ((<SDL::Event::MouseButtonUp#button>)) -- The mouse button index
  * ((<SDL::Event::MouseButtonUp#press>)) -- Whether mouse button is pressed or not
  * ((<SDL::Event::MouseButtonUp#x>)) -- The X coordinate of the mouse at release time
  * ((<SDL::Event::MouseButtonUp#y>)) -- The Y coordinate of the mouse at release time.
  * ((<SDL::Event::JoyAxis#which>)) -- Joystick device index
  * ((<SDL::Event::JoyAxis#axis>)) -- JoyAxis axis index
  * ((<SDL::Event::JoyAxis#value>)) -- Axis value
  * ((<SDL::Event::JoyBall#which>)) -- Joystick device index
  * ((<SDL::Event::JoyBall#ball>)) -- Joystick trackball index
  * ((<SDL::Event::JoyBall#xrel>)) -- The relative motion in the X direction
  * ((<SDL::Event::JoyBall#yrel>)) -- The relative motion in the Y direction.
  * ((<SDL::Event::JoyHat#which>)) -- Joystick device index
  * ((<SDL::Event::JoyHat#hat>)) -- Joystick hat index
  * ((<SDL::Event::JoyHat#value>)) -- Hat position
  * ((<SDL::Event::JoyButtonDown#which>)) -- Joystick device index
  * ((<SDL::Event::JoyButtonDown#button>)) -- Joystick button index
  * ((<SDL::Event::JoyButtonDown#press>)) -- Joystick button is pressed or released
  * ((<SDL::Event::JoyButtonUp#which>)) -- Joystick device index
  * ((<SDL::Event::JoyButtonUp#button>)) -- Joystick button index
  * ((<SDL::Event::JoyButtonUp#press>)) -- Joystick button is pressed or released
  * ((<SDL::Event::VideoResize#w>)) -- New width of the window.
  * ((<SDL::Event::VideoResize#h>)) -- New height of the window 
  * ((<SDL::Key.scan>)) -- Get a snapshot of the current keyboard state
  * ((<SDL::Key.press?>)) -- Get the current keyboard state.
  * ((<SDL::Key.mod_state>)) -- Get the state of modifier keys.
  * ((<SDL::Key.get_key_name>)) -- Get the name of an SDL virtual keysym
  * ((<SDL::Key.enable_key_repeat>)) -- Set keyboard repeat rate.
  * ((<SDL::Key.disable_key_repeat>)) -- Disable key repeat.
  * ((<SDL::Mouse.state>)) -- Retrieve the current state of the mouse
  * ((<SDL::Mouse.warp>)) -- Set the position of the mouse cursor.
  * ((<SDL::Mouse.show>)) -- Toggle the cursor is shown on the screen.
  * ((<SDL::Mouse.hide>)) -- Hide cursor.
  * ((<SDL::Mouse.show?>)) -- Get the state of mouse cursor.
  * ((<SDL::Mouse.set_cursor>)) -- Set the currently active mouse cursor.

== Event system Overview
Event handling allows your application to receive input from the user.
Event handling is initalised (along with video) with a call to:
  SDL_Init(SDL_INIT_VIDEO);
Internally, SDL stores all the events waiting to be handled in an event queue.
Using functions like ((<SDL::Event.poll>)) and ((<SDL::Event.wait>))
you can observe and handle waiting input events.

The key to event handling in SDL is the subclasses of ((<SDL::Event>)).
The event queue itself is composed of a series of 
instance of (subclasses of) ((<SDL::Event>)), one for each waiting event.
Those objects are read from queue with the ((<SDL::Event.poll>)) and it is
then up to the application to process the information stored with them.

Subclasses of ((<SDL::Event>)) is following:
* ((<SDL::Event::Active>))
* ((<SDL::Event::KeyDown>))
* ((<SDL::Event::KeyUp>))
* ((<SDL::Event::MouseMotion>))
* ((<SDL::Event::MouseButtonDown>))
* ((<SDL::Event::MouseButtonUp>))
* ((<SDL::Event::JoyAxis>))
* ((<SDL::Event::JoyBall>))
* ((<SDL::Event::JoyHat>))
* ((<SDL::Event::JoyButtonDown>))
* ((<SDL::Event::JoyButtonUp>))
* ((<SDL::Event::Quit>))
* ((<SDL::Event::SysWM>))
* ((<SDL::Event::VideoResize>))
* ((<SDL::Event::VideoExpose>))

Those classes have two uses.
* Reading events on the event queue.
* Placing events on the event queue.

Reading events from the event queue is done with ((<SDL::Event.poll>)).
We'll use ((<SDL::Event.poll>)) and step through an example.
((<SDL::Event.poll>)) removes the next event from the event queue, 
if there are no events on the queue it returns nil
otherwise it returns event object. 
We use a while loop to process each event in turn.

  while event = SDL::Event.poll

We know that if ((<SDL::Event.poll>)) removes an event from the queue then the event information will
be placed in returned object, but we also know that the class of that object will represent
the type of event. So we handle each event type seperately we use a switch statement.

  case event

We need to know what kind of events we're looking for ((*and*)) the event type's of those events.
So lets assume we want to detect where the user is moving the mouse pointer within our application.
We look through our event types and notice that ((<SDL::Event::MouseMotion>)) is, more than likely,
the event we're looking for. A little more research tells use that
mouse motion events are handled within the ((<SDL::Event::MouseMotion>)).
We can check for the mouse motion event type within our switch statement like so:

  when SDL::Event::MouseMotion

All we need do now is read the information out of this object as instance 
of ((<SDL::Event::MouseMotion>)).
  
    puts "We got a motion event"
    puts "Current mouse position is: (#{event.x}, #{event.y})"
  else
    puts "Unhandled Event!"
  end
  end
  puts "Event queue is empty."

It is also possible to push events onto the event queue.
[Event.push]  allows you to place events onto the event queue.
You can use it to post fake input events if you wished.

== SDL::Event
This class handle events. All objects returned by ((<SDL::Event.poll>)) are
instances of subclasses of SDL::Event.

== Compatiblity
The class that used to be known as SDL::Event is remove.
The class now called SDL::Event was called SDL::Event2 before.
A constant SDL::Event2 remains as alias of SDL::Event because of compatiblity with older version.

== SDL::Event::Active
Class for Application visibility event.

This event raises when the mouse leaves or enters the window area,
the application loses or gains keyboard focus,
or the application is either minimised/iconified or restored.

((<SDL::Event::Active#state>)) returns which event occurs.

* NOTES

  This event does not occur when an application window is first created.

* ((<SDL::Event::Active#gain>)) -- Returns whether gaining visibility or not
* ((<SDL::Event::Active#state>)) -- Gets the type of visibility event.

== SDL::Event::KeyDown

Class for keyboard down event.

* ((<SDL::Event::KeyDown#press>)) -- Returns true.
* ((<SDL::Event::KeyDown#sym>)) -- Get the key symbol of pressed key
* ((<SDL::Event::KeyDown#mod>)) -- Current key modifier
* ((<SDL::Event::KeyDown#unicode>)) -- Translated character

== SDL::Event::KeyUp

Class for key up event.

* ((<SDL::Event::KeyUp#press>)) -- Whether key is pressed
* ((<SDL::Event::KeyUp#sym>)) -- Get the key symbol of released key
* ((<SDL::Event::KeyUp#mod>)) -- Current key modifier

== SDL::Event::MouseMotion

Class for mouse motion event.

Simply put, a event of this type occurs 
when a user moves the mouse within the application window or when [Mouse.warp] is called.
Both the absolute coordinate (((<SDL::Event::MouseMotion#x>)) and ((<SDL::Event::MouseMotion#y>))) and
relative coordinate (((<SDL::Event::MouseMotion#xrel>)) and ((<SDL::Event::MouseMotion#yrel>))) 
are reported along with the current button states (((<SDL::Event::MouseMotion#state>))).

* ((<SDL::Event::MouseMotion#state>)) -- The current button state
* ((<SDL::Event::MouseMotion#x>)) -- The X coordinate of the mouse
* ((<SDL::Event::MouseMotion#y>)) -- the X coordinate of the mouse.
* ((<SDL::Event::MouseMotion#xrel>)) -- Relative motion in the X direction
* ((<SDL::Event::MouseMotion#yrel>)) -- Relative motion in the Y direction

== SDL::Event::MouseButtonDown
Class for mouse button press event.

This type of event occurs when a mouse button press is detected.

* ((<SDL::Event::MouseButtonDown#button>)) -- The mouse button index
* ((<SDL::Event::MouseButtonDown#press>)) -- Whether mouse button is pressed or not
* ((<SDL::Event::MouseButtonDown#x>)) -- The X coordinate of the mouse at press time.
* ((<SDL::Event::MouseButtonDown#y>)) -- The Y coordinate of the mouse at press time

== SDL::Event::MouseButtonUp
Class for mouse button release event.

This type of event occurs when a mouse button release is detected.

* ((<SDL::Event::MouseButtonUp#button>)) -- The mouse button index
* ((<SDL::Event::MouseButtonUp#press>)) -- Whether mouse button is pressed or not
* ((<SDL::Event::MouseButtonUp#x>)) -- The X coordinate of the mouse at release time
* ((<SDL::Event::MouseButtonUp#y>)) -- The Y coordinate of the mouse at release time.

== SDL::Event::JoyAxis
Class for joystick axis motion event. 

This event occurs when ever a user moves an axis on the joystick. 

* ((<SDL::Event::JoyAxis#which>)) -- Joystick device index
* ((<SDL::Event::JoyAxis#axis>)) -- JoyAxis axis index
* ((<SDL::Event::JoyAxis#value>)) -- Axis value

* SEEALSO
  ((<SDL::Joystick#num_axes>)), ((<SDL::Joystick#axis>))

== SDL::Event::JoyBall
Class for joystick ball motion event.

This type of event occurs when a user moves a trackball on the joystick.

* ((<SDL::Event::JoyBall#which>)) -- Joystick device index
* ((<SDL::Event::JoyBall#ball>)) -- Joystick trackball index
* ((<SDL::Event::JoyBall#xrel>)) -- The relative motion in the X direction
* ((<SDL::Event::JoyBall#yrel>)) -- The relative motion in the Y direction.

* SEEALSO

  ((<SDL::Joystick#num_balls>)), ((<SDL::Joystick#ball>))

== SDL::Event::JoyHat
Class for joystick hat position change event.

* ((<SDL::Event::JoyHat#which>)) -- Joystick device index
* ((<SDL::Event::JoyHat#hat>)) -- Joystick hat index
* ((<SDL::Event::JoyHat#value>)) -- Hat position

* SEEALSO
  
  ((<SDL::Joystick#num_hats>)), ((<SDL::Joystick#hat>))

== SDL::Event::JoyButtonDown
Class for joystick button press event.

This event occurs when a user presses a button on a joystick.

* ((<SDL::Event::JoyButtonDown#which>)) -- Joystick device index
* ((<SDL::Event::JoyButtonDown#button>)) -- Joystick button index
* ((<SDL::Event::JoyButtonDown#press>)) -- Joystick button is pressed or released

* SEEALSO

  ((<SDL::Joystick#num_buttons>)), ((<SDL::Joystick#button>))

== SDL::Event::JoyButtonUp
Class for joystick button release event.

This event occurs when a user releases a button on a joystick.

* ((<SDL::Event::JoyButtonUp#which>)) -- Joystick device index
* ((<SDL::Event::JoyButtonUp#button>)) -- Joystick button index
* ((<SDL::Event::JoyButtonUp#press>)) -- Joystick button is pressed or released

* SEEALSO

  ((<SDL::Joystick#num_buttons>)), ((<SDL::Joystick#button>))

== SDL::Event::Quit
Class for quit reqested event.

This event is very important.
If you filter out or ignore a quit event then it is impossible for the user to
close the window. On the other hand, if you do accept a quit event then the application window will be
closed, and screen updates will still report success event though the application will no longer be
visible.

== SDL::Event::SysWM
Class for platform-dependent window manager event.

Event of this type occurs when unknown window manager event happens.
You can never know the detail of this event.
Only you can to do is to ignore this event.

== SDL::Event::VideoResize
Class for window resize event.

When SDL::RESIZABLE is passed as a ((|flag|)) to 
((<SDL::Screen.open>)) the user is allowed to resize the applications
window. When the window is resized an event of this type is report,
with the new window width and height values stored in ((<SDL::Event::VideoResize#w>)) and
 ((<SDL::Event::VideoResize#h>)) respectively.

When this event is recieved the window should be resized
to the new dimensions using ((<SDL::Screen.open>)).

== SDL::Event::VideoExpose
Class for video expose event.

This event is triggered when the screen has been modified outside of the application, usually by
the window manager and needs to be redrawn.

== SDL::Key
Module for keyboard input.

This module defines some keyboard-related constants and 
module functions.

* ((<SDL::Key.scan>)) -- Get a snapshot of the current keyboard state
* ((<SDL::Key.press?>)) -- Get the current keyboard state.
* ((<SDL::Key.mod_state>)) -- Get the state of modifier keys.
* ((<SDL::Key.get_key_name>)) -- Get the name of an SDL virtual keysym
* ((<SDL::Key.enable_key_repeat>)) -- Set keyboard repeat rate.
* ((<SDL::Key.disable_key_repeat>)) -- Disable key repeat.

=== Key symbol
Key symbol constants definitions.
* SDL::Key::BACKSPACE  '\b'  backspace  
* SDL::Key::TAB  '\t' tab  
* SDL::Key::CLEAR     clear
* SDL::Key::RETURN  '\r'  return
* SDL::Key::PAUSE    pause
* SDL::Key::ESCAPE  '^['  escape
* SDL::Key::SPACE  ' '   space
* SDL::Key::EXCLAIM  '!'   exclaim
* SDL::Key::QUOTEDBL  '"'   quotedbl
* SDL::Key::HASH  '#'   hash
* SDL::Key::DOLLAR  '$'   dollar
* SDL::Key::AMPERSAND  '&'  ampersand
* SDL::Key::QUOTE  '''  quote
* SDL::Key::LEFTPAREN  '('   left parenthesis
* SDL::Key::RIGHTPAREN  ')'  right parenthesis
* SDL::Key::ASTERISK  '*'  asterisk
* SDL::Key::PLUS  '+'  plus sign
* SDL::Key::COMMA  ','  comma
* SDL::Key::MINUS  '-'  minus sign
* SDL::Key::PERIOD  '.'  period
* SDL::Key::SLASH  '/'  forward slash
* SDL::Key::K0  '0'  0
* SDL::Key::K1  '1'  1
* SDL::Key::K2  '2'  2
* SDL::Key::K3  '3'  3
* SDL::Key::K4  '4'  4
* SDL::Key::K5  '5'  5
* SDL::Key::K6  '6'  6
* SDL::Key::K7  '7'  7
* SDL::Key::K8  '8'  8
* SDL::Key::K9  '9'  9
* SDL::Key::COLON  ':'  colon
* SDL::Key::SEMICOLON  ';'  semicolon
* SDL::Key::LESS  '&lt;'  less-than sign
* SDL::Key::EQUALS  '='   equals sign
* SDL::Key::GREATER  '&gt;'   greater-than sign
* SDL::Key::QUESTION  '?'   question mark
* SDL::Key::AT  '@'   at
* SDL::Key::LEFTBRACKET  '['   left bracket
* SDL::Key::BACKSLASH  '\'   backslash
* SDL::Key::RIGHTBRACKET  ']'   right bracket
* SDL::Key::CARET  '^'   caret
* SDL::Key::UNDERSCORE  '_'   underscore
* SDL::Key::BACKQUOTE  '`'   grave
* SDL::Key::A  'a'  a  
* SDL::Key::B  'b'  b  
* SDL::Key::C  'c'  c  
* SDL::Key::D  'd'  d  
* SDL::Key::E  'e'  e  
* SDL::Key::F  'f'  f  
* SDL::Key::G  'g'  g  
* SDL::Key::H  'h'  h  
* SDL::Key::I  'i'  i  
* SDL::Key::J  'j'  j  
* SDL::Key::K  'k'  k  
* SDL::Key::L  'l'  l  
* SDL::Key::M  'm'  m  
* SDL::Key::N  'n'  n  
* SDL::Key::O  'o'  o  
* SDL::Key::P  'p'  p  
* SDL::Key::Q  'q'  q  
* SDL::Key::R  'r'  r  
* SDL::Key::S  's'  s  
* SDL::Key::T  't'  t  
* SDL::Key::U  'u'  u  
* SDL::Key::V  'v'  v  
* SDL::Key::W  'w'  w  
* SDL::Key::X  'x'  x  
* SDL::Key::Y  'y'  y  
* SDL::Key::Z  'z'  z  
* SDL::Key::DELETE  '^?'  delete  
* SDL::Key::KP0     keypad 0
* SDL::Key::KP1     keypad 1
* SDL::Key::KP2     keypad 2
* SDL::Key::KP3     keypad 3
* SDL::Key::KP4     keypad 4
* SDL::Key::KP5     keypad 5
* SDL::Key::KP6     keypad 6
* SDL::Key::KP7     keypad 7
* SDL::Key::KP8     keypad 8
* SDL::Key::KP9     keypad 9
* SDL::Key::KP_PERIOD  '.'   keypad period
* SDL::Key::KP_DIVIDE  '/'   keypad divide
* SDL::Key::KP_MULTIPLY  '*'   keypad multiply
* SDL::Key::KP_MINUS  '-'   keypad minus
* SDL::Key::KP_PLUS  '+'   keypad plus
* SDL::Key::KP_ENTER  '\r'   keypad enter
* SDL::Key::KP_EQUALS  '='   keypad equals
* SDL::Key::UP     up arrow
* SDL::Key::DOWN     down arrow
* SDL::Key::RIGHT     right arrow
* SDL::Key::LEFT     left arrow
* SDL::Key::INSERT    insert  
* SDL::Key::HOME    home  
* SDL::Key::END    end  
* SDL::Key::PAGEUP    page up  
* SDL::Key::PAGEDOWN    page down  
* SDL::Key::F1    F1  
* SDL::Key::F2    F2  
* SDL::Key::F3    F3  
* SDL::Key::F4    F4  
* SDL::Key::F5    F5  
* SDL::Key::F6    F6  
* SDL::Key::F7    F7  
* SDL::Key::F8    F8  
* SDL::Key::F9    F9  
* SDL::Key::F10    F10  
* SDL::Key::F11    F11  
* SDL::Key::F12    F12  
* SDL::Key::F13    F13  
* SDL::Key::F14    F14  
* SDL::Key::F15    F15  
* SDL::Key::NUMLOCK    numlock  
* SDL::Key::CAPSLOCK    capslock  
* SDL::Key::SCROLLOCK    scrollock  
* SDL::Key::RSHIFT     right shift
* SDL::Key::LSHIFT     left shift
* SDL::Key::RCTRL     right ctrl
* SDL::Key::LCTRL     left ctrl
* SDL::Key::RALT     right alt
* SDL::Key::LALT     left alt
* SDL::Key::RMETA     right meta
* SDL::Key::LMETA     left meta
* SDL::Key::LSUPER     left windows key
* SDL::Key::RSUPER     right windows key
* SDL::Key::MODE     mode shift
* SDL::Key::HELP    help  
* SDL::Key::PRINT    print-screen  
* SDL::Key::SYSREQ    SysRq  
* SDL::Key::BREAK    break  
* SDL::Key::MENU    menu  
* SDL::Key::POWER    power  
* SDL::Key::EURO     euro

== SDL::Mouse
Module for mouse input.

This module defines some mouse constants and module functions.

* ((<SDL::Mouse.state>)) -- Retrieve the current state of the mouse
* ((<SDL::Mouse.warp>)) -- Set the position of the mouse cursor.
* ((<SDL::Mouse.show>)) -- Toggle the cursor is shown on the screen.
* ((<SDL::Mouse.hide>)) -- Hide cursor.
* ((<SDL::Mouse.show?>)) -- Get the state of mouse cursor.
* ((<SDL::Mouse.set_cursor>)) -- Set the currently active mouse cursor.
== Methods

--- SDL::Event.poll

    Polls for currently pending events, and returns event object if there
    are any pending events, or nil if there are none
    available.
    
    If event object is returned, the next event is removed from 
    the queue and stored in that area.


    EXAMPLE
      while event = SDL::Event.poll # Loop until there are no events left on the queue
        case event # Process the appropiate event type
        when SDL::Event::KeyDown # Handle a KEYDOWN event
          puts "Oh! Key press"
        when SDL::Event::MouseMotion
          .
          .
          .
        else # Report an unhandled event
          puts "I don't know what this event is!"
        end
      end

    * See Also
      
      ((<SDL::Event>)), ((<SDL::Event.wait>))

--- SDL::Event.wait

    Waits indefinitely for the next available event and return that event.
    
    If event object is returned, the next event is removed
    from the queue and stored in that area.

    Raise ((<SDL::Error>)) if there was an error while waiting
    for events.

    * NOTES

      In Ruby 1.9 and above, this method releases the global VM lock (GVL) prior to
      calling the underlying SDL_WaitEvent function.  This allows other Ruby threads to
      continue executing while waiting for an event.
      
      In Ruby 1.8 and below, there is no way to release the GVL, so all Ruby threads
      suspend execution until this method finishes.
      
      This method may return nil when Ruby/SDL encounters an unknown type of event.
      You should treat this case.

    * See Also
      
      ((<SDL::Event.poll>))

--- SDL::Event.push(event)

    Push ((|event|)) onto event queue.

    Raises ((<SDL::Error>)) on failure
    * NOTES

      Pushing device input events onto the queue doesn't modify the 
      state of the device within SDL.

    * See Also
      
      ((<SDL::Event.poll>))

--- SDL::Event.app_state
--- SDL::Event.appState

    This method returns the current state of the application. 
    The value returned is a bitwise combination of:
    :SDL::Event::APPMOUSEFOCUS
      The application has mouse focus. 
    :SDL::Event::APPINPUTFOCUS
      The application has keyboard focus.
    :SDL::Event::APPACTIVE
      The application is visible.

    * See Also
      
      ((<SDL::Event::Active>))

--- SDL::Event.enable_unicode
--- SDL::Event.enableUNICODE

    To obtain the character codes corresponding to received keyboard events, Unicode translation must first
    be turned on using this function. The translation incurs a slight overhead for each keyboard event and is
    therefore disabled by default. For each subsequently received key down event, 
    ((<SDL::Event::KeyDown#unicode>)) will then contain the corresponding character code, 
    or zero for keysyms that do not correspond to any character code.

    * NOTES

      Note that only key press events will be translated, not release events.

    * See Also
      
      ((<SDL::Event.disable_unicode>)), ((<SDL::Event.enable_unicode?>))

--- SDL::Event.disable_unicode
--- SDL::Event.disableUNICODE

    Disables Unicode keyboard translation. Please see ((<SDL::Event.enable_unicode>))
    in detail.

--- SDL::Event.enable_unicode?
--- SDL::Event.enableUNICODE?

    Returns true if Unicode keyboard translation is enabled, otherwise
    returns false. Please see ((<SDL::Event.enable_unicode>)) in detail.

--- SDL::Event::Active#gain

    Returns true if the mouse enters the window, the application gains keyboard focus, or
    minimized/iconcified window is restored.
    Otherwise returns false.

    * See Also
      
      ((<SDL::Event::Active>)), ((<SDL::Event::Active#state>))

--- SDL::Event::Active#state

    Returns one of following three constants:
    * SDL::Event::APPMOUSEFOCUS
    
      This event occurs when the mouse leaves or enters the window area.
    
    * SDL::Event::APPINPUTFOCUS
    
      THis event occurs when the application loses or gains input focus.
    
    * SDL::Event::APPACTIVE
    
      This event occurs when the application is either minimized/iconcified or restored.

    * See Also
      
      ((<SDL::Event::Active>)), ((<SDL::Event::Active#gain>))

--- SDL::Event::KeyDown#press

    Always returns true.

    * See Also
      
      ((<SDL::Event::KeyUp#press>))

--- SDL::Event::KeyDown#sym

    Returns pressed ((<Key symbol>)).

    * See Also
      
      ((<SDL::Event::KeyDown#unicode>))

--- SDL::Event::KeyDown#mod

    Returns the current state of keyboard modifiers as explained in ((<SDL::Key.mod_state>)).

    * See Also
      
      ((<SDL::Key.mod_state>))

--- SDL::Event::KeyDown#unicode

    Returns the UNICODE character corresponding to the keypress if Unicode translation
    is enabled with ((<SDL::Event.enable_unicode>)). 
    If the high 9 bits of the character are 0, then this
    maps to the equivalent ASCII character:
    
    Returns zero if unicode translation is disabled.

--- SDL::Event::KeyUp#press

    Always returns false.

    * See Also
      
      ((<SDL::Event::KeyDown#press>))

--- SDL::Event::KeyUp#sym

    Returns the released ((<Key symbol>))

--- SDL::Event::KeyUp#mod

    Returns the current state of keyboard modifiers as explained in ((<SDL::Key.mod_state>)).

    * See Also
      
      ((<SDL::Key.mod_state>))

--- SDL::Event::MouseMotion#state

    Returns the current button state.
    The value returned is a bitwise combination of:
    
    :SDL::Mouse::BUTTON_LMASK
      Left button
    :SDL::Mouse::BUTTON_MMASK
      Middle button
    :SDL::Mouse::BUTTON_RMASK
      Right button

    * See Also
      
      ((<SDL::Mouse.state>))

--- SDL::Event::MouseMotion#x

    Returns the X coordinate of the mouse.

    * See Also
      
      ((<SDL::Mouse.state>))

--- SDL::Event::MouseMotion#y

    Returns the Y coordinate of the mouse.

    * See Also
      
      ((<SDL::Mouse.state>))

--- SDL::Event::MouseMotion#xrel

    Returns relative motion in the X direction.

--- SDL::Event::MouseMotion#yrel

    Returns relative motion in the Y direction.

--- SDL::Event::MouseButtonDown#button

    Returns number of the button pressed:
    * SDL::Mouse::BUTTON_LEFT
    * SDL::Mouse::BUTTON_MIDDLE
    * SDL::Mouse::BUTTON_RIGHT

--- SDL::Event::MouseButtonDown#press

    Always returns true.

    * See Also
      
      ((<SDL::Event::MouseButtonUp#press>))

--- SDL::Event::MouseButtonDown#x

    Returns the X coordinate of the mouse.

    * See Also
      
      ((<SDL::Mouse.state>))

--- SDL::Event::MouseButtonDown#y

    Returns the Y coordinate of the mouse at press time.

    * See Also
      
      ((<SDL::Mouse.state>))

--- SDL::Event::MouseButtonUp#button

    Returns number of the button released:
    * SDL::Mouse::BUTTON_LEFT
    * SDL::Mouse::BUTTON_MIDDLE
    * SDL::Mouse::BUTTON_RIGHT

--- SDL::Event::MouseButtonUp#press

    Always returns false.

    * See Also
      
      ((<SDL::Event::MouseButtonDown#press>))

--- SDL::Event::MouseButtonUp#x

    Returns the X coordinate of the mouse at release time.

    * See Also
      
      ((<SDL::Mouse.state>))

--- SDL::Event::MouseButtonUp#y

    Returns the Y coordinate of the mouse at release time.

    * See Also
      
      ((<SDL::Mouse.state>))

--- SDL::Event::JoyAxis#which

    Returns the index of the joystick that reported the event.

    * See Also
      
      ((<SDL::Joystick>)), ((<SDL::Joystick#num_axes>))

--- SDL::Event::JoyAxis#axis

    Returns the index of the axis that reported the event.

    * See Also
      
      ((<SDL::Joystick>))

--- SDL::Event::JoyAxis#value

    Returns the position of the axis in -32767 .. 32767.

    * See Also
      
      ((<SDL::Joystick>)), ((<SDL::Joystick#axis>))

--- SDL::Event::JoyBall#which

    Returns the index of the joystick that reported the event.

    * See Also
      
      ((<SDL::Joystick>))

--- SDL::Event::JoyBall#ball

    Returns the index of the trackball that reported the event.

    * See Also
      
      ((<SDL::Joystick>)), ((<SDL::Joystick#num_balls>))

--- SDL::Event::JoyBall#xrel

    Returns the relative motion in the X direction as Integer.
    This value is the change in position on the ball since it was last polled.

    * See Also
      
      ((<SDL::Joystick>)), ((<SDL::Joystick#ball>))

--- SDL::Event::JoyBall#yrel

    Returns the relative motion in the Y direction as Integer.
    This value is the change in position on the ball since it was last polled.

    * See Also
      
      ((<SDL::Joystick>)), ((<SDL::Joystick#ball>))

--- SDL::Event::JoyHat#which

    Returns the index of the joystick that reported the event.

    * See Also
      
      ((<SDL::Joystick>))

--- SDL::Event::JoyHat#hat

    Returns the index of the hat that reported the event.

    * See Also
      
      ((<SDL::Joystick>)), ((<SDL::Joystick#num_hats>))

--- SDL::Event::JoyHat#value

    Returns the current position of the hat. It is a logically OR'd
    combination of the following values (whose meanings should be pretty obvious:) :
    
    * SDL::Joystick::HAT_CENTERED
    * SDL::Joystick::HAT_UP
    * SDL::Joystick::HAT_RIGHT
    * SDL::Joystick::HAT_DOWN
    * SDL::Joystick::HAT_LEFT
    
    The following defines are also provided:
    * SDL::Joystick::HAT_RIGHTUP
    * SDL::Joystick::HAT_RIGHTDOWN
    * SDL::Joystick::HAT_LEFTUP
    * SDL::Joystick::HAT_LEFTDOWN

--- SDL::Event::JoyButtonDown#which

    Returns the index of the joystick that reported the event.

    * See Also
      
      ((<SDL::Joystick>))

--- SDL::Event::JoyButtonDown#button

    Returns the index of the button that reported the event.

    * See Also
      
      ((<SDL::Joystick>)), ((<SDL::Joystick#num_buttons>))

--- SDL::Event::JoyButtonDown#press

    Returns whether this event is button press event.
    Always returns true.

    * See Also
      
      ((<SDL::Event::JoyButtonUp#press>)), ((<SDL::Joystick#button>))

--- SDL::Event::JoyButtonUp#which

    Returns the index of the joystick that reported the event.

    * See Also
      
      ((<SDL::Joystick>))

--- SDL::Event::JoyButtonUp#button

    Returns the index of the button that reported the event.

    * See Also
      
      ((<SDL::Joystick>)), ((<SDL::Joystick#num_buttons>))

--- SDL::Event::JoyButtonUp#press

    Returns whether this event is button press event.
    Always returns false.

    * See Also
      
      ((<SDL::Event::JoyButtonDown#press>)), ((<SDL::Joystick#button>))

--- SDL::Event::VideoResize#w

    Returns the new width of the window when window is resized.

--- SDL::Event::VideoResize#h

    Returns the new width of the window when window is resized.

--- SDL::Key.scan

    Gets a snapshot of the current keyboard state.
    You can check this state with ((<SDL::Key.press?>)).
    
    NOTE
    Call ((<SDL::Event.poll>)) or ((<SDL::Event.wait>)) to update the state.

    * See Also
      
      ((<SDL::Key.press?>)), ((<SDL::Event::KeyDown>)), ((<SDL::Event::KeyUp>)), ((<SDL::Event.poll>))

--- SDL::Key.press?(key)

    Returns true if ((|key|)) is pressed, otherwise returns false.
    Please use ((<Key symbol>)) as parameter.

    * See Also
      
      ((<SDL::Key.scan>)), ((<SDL::Event::KeyDown>)), ((<SDL::Event::KeyUp>))

--- SDL::Key.mod_state
--- SDL::Key.modState

    Returns the current state of the modifier keys (CTRL, ALT, etc.).
    The return value can be an OR'd combination of:
    :SDL::Key::MOD_NONE
    :SDL::Key::MOD_LSHIFT
    :SDL::Key::MOD_RSHIFT
    :SDL::Key::MOD_LCTRL
    :SDL::Key::MOD_RCTRL
    :SDL::Key::MOD_LALT
    :SDL::Key::MOD_RALT
    :SDL::Key::MOD_LMETA
    :SDL::Key::MOD_RMETA
    :SDL::Key::MOD_NUM
    :SDL::Key::MOD_CAPS
    :SDL::Key::MOD_MODE
     
    SDL also defines the following symbols for convenience:
    * SDL::Key::MOD_CTRL = SDL::Key::MOD_LCTRL|SDL::Key::MOD_RCTRL
    * SDL::Key::MOD_SHIFT = SDL::Key::MOD_LSHIFT|SDL::Key::MOD_RSHIFT
    * SDL::Key::MOD_ALT = SDL::Key::MOD_LALT|SDL::Key::MOD_RALT
    * SDL::Key::MOD_META = SDL::Key::MOD_LMETA|SDL::Key::MOD_RMETA

    * See Also
      
      ((<SDL::Key.scan>))

--- SDL::Key.get_key_name(key)
--- SDL::Key.getKeyName(key)

    Returns the SDL-defined name of the ((|key|)) ((<key symbol|Key symbol>)).

--- SDL::Key.enable_key_repeat(delay,interval)
--- SDL::Key.enableKeyRepeat(delay,interval)

    Enables the keyboard repeat rate. ((|delay|)) specifies how long the key must be pressed before it
    begins repeating, it then repeats at the speed specified by ((|interval|)). Both delay and interval are
    expressed in milliseconds.
    
    Good default values are SDL::Key::DEFAULT_REPEAT_DELAY and 
    SDL::Key::DEFAULT_REPEAT_INTERVAL.

    Raises ((<SDL::Error>)) on failure
    * See Also
      
      ((<SDL::Key.disable_key_repeat>))

--- SDL::Key.disable_key_repeat
--- SDL::Key.disableKeyRepeat

    Disables key repeat.

    Raises ((<SDL::Error>)) on failure
    * See Also
      
      ((<SDL::Key.enable_key_repeat>))

--- SDL::Mouse.state

    Returns an array of five element:
      [ X coordinate, Y coordinate, left button is pressed?, middle button is pressed?, right button is pressed?]


    EXAMPLE
      x, y, lbutton, * = SDL::Mouse.state
      if lbutton
        print "Left Mouse Button is pressed \n"
      end

    * See Also
      
      ((<SDL::Event::MouseMotion>)), ((<SDL::Event::MouseButtonDown>)), ((<SDL::Event::MouseButtonUp>))

--- SDL::Mouse.warp(x,y)

    Set the position of the mouse cursor (generates a mouse motion event).

    * See Also
      
      ((<SDL::Event::MouseMotion>))

--- SDL::Mouse.show

    Shows cursor.
    
    The cursor starts off displayed, but can be turned off.

    * See Also
      
      ((<SDL::Mouse.hide>)), ((<SDL::Mouse.show?>))

--- SDL::Mouse.hide

    Hide cursor.

    * See Also
      
      ((<SDL::Mouse.show>)), ((<SDL::Mouse.show?>))

--- SDL::Mouse.show?

    Returns true if mouse cursor is shown, otherwise returns false.

    * See Also
      
      ((<SDL::Mouse.show>)), ((<SDL::Mouse.hide>))

--- SDL::Mouse.set_cursor(bitmap,white,black,transparent,inverted,hot_x=0,hot_y=0)
--- SDL::Mouse.setCursor(bitmap,white,black,transparent,inverted,hot_x=0,hot_y=0)

    Sets the currently active cursor to the specified one. If the cursor is currently visible, the change
    will be immediately represented on the display.
    
    ((|bitmap|)) is shape of cursor, given by the instance of ((<SDL::Surface>)).
    ((|white|)) is white color pixel value in ((|bitmap|)), 
    ((|black|)) is black color pixel value in ((|bitmap|)), 
    ((|transparent|)) is transparent pixel value in ((|bitmap|)), 
    ((|inverted|)) is inverted pixel value in ((|bitmap|)).
    The cursor width must be a multiple of 8 bits.

    * See Also
      
      ((<SDL::Surface>))

