-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Sem.Walk_Expression_P.Walk_Annotation_Expression)
procedure Down_Wf_Store_List
  (Node      : in     STree.SyntaxNode;
   Scope     : in     Dictionary.Scopes;
   E_Stack   : in out Exp_Stack.Exp_Stack_Type;
   Next_Node :    out STree.SyntaxNode)
is
   Type_Info : Sem.Exp_Record;
begin
   -- this procedure does nothing if an array update is being processed other
   -- than set Next_Node to the STree.Child_Node of Node.  For records it prunes
   -- so that the expression tree walk does not stumble into the field ident.
   -- Checks at down_wf_store ensure that we have either an array or record
   -- object at this point so we don not need any more checks of this.
   Exp_Stack.Pop (Item  => Type_Info,
                  Stack => E_Stack);
   if Dictionary.IsRecordTypeMark (Type_Info.Type_Symbol, Scope) then
      Next_Node := STree.NullNode; -- prune
   else
      Next_Node := STree.Child_Node (Current_Node => Node);
      -- ASSUME Next_Node = store_list OR annotation_expression
      SystemErrors.RT_Assert
        (C       => STree.Syntax_Node_Type (Node => Next_Node) = SP_Symbols.store_list
           or else STree.Syntax_Node_Type (Node => Next_Node) = SP_Symbols.annotation_expression,
         Sys_Err => SystemErrors.Invalid_Syntax_Tree,
         Msg     => "Expect Next_Node = store_list OR annotation_expression in Down_Wf_Store_List");
   end if;
   Exp_Stack.Push (X     => Type_Info,
                   Stack => E_Stack); -- restore stack
end Down_Wf_Store_List;
