#===================================
#		   stackapplet
#  Copyright 2011 - Nathan Osman
#
#  Allows StackApplet to receive
#     Win32 notifications
#
#   StackApplet is released under
#		the MIT license
#===================================

# Win32 modules
import win32gui
import win32api
import win32con

stackapplet_instance = None

# Provides the main Py file with a way to
# give us a reference to itself
def register_main_instance(inst):
	
	global stackapplet_instance
	stackapplet_instance = inst

# The window procedure that will receive the
# messages.
def window_procedure(hwnd, msg, wparam, lparam):
	
	if msg == win32con.WM_QUERYENDSESSION:
		
		global stackapplet_instance
		stackapplet_instance.shutdown()
	
	return win32gui.DefWindowProc(hwnd, msg, wparam, lparam)

# Create the window that we
# will use to receive notifications
window_class = win32gui.WNDCLASS()

window_class.lpszClassName = 'test_window'
window_class.lpfnWndProc   = window_procedure

win32gui.RegisterClass(window_class)
hinst = win32api.GetModuleHandle(None)

main_window = win32gui.CreateWindowEx(0,
                                      'test_window',
                                      '',
                                      win32con.WS_POPUP,
                                      0, 0, 0, 0, 0, 0,
                                      hinst,
                                      None)

# and we're done!
