use core:lang;
use core:debug;
use core:io;
use lang:bs;

// Very hacky proof-of-concept code reloads.

void reload(SrcName name) on Compiler {
	Named? pkg = rootScope.find(name);
	if (pkg as Package) {
		print("Reloading " # name # "...");
		reloadPkg(pkg);
		print("OK!");
	} else {
		print("We can only reload packages at the moment.");
	}
}

void reloadPkg(Package pkg) on Compiler {
	print("WARNING: This is a very hacky reload that is only for convenience until the " #
		"real version is done. Will only reload functions, and does not provide any decent " #
		"error messages!");

	Url? url = pkg.url;
	if (url) {
		Url[] children = url.children;
		for (Nat i = 0; i < children.count; i++) {
			reloadUrl(pkg, children[i]);
		}
	} else {
		print("This package is virtual. Can not reload it!");
	}
}

void reloadUrl(Package pkg, Url url) on Compiler {
	if (url.dir) {
	} else if (url.ext == "bs") {
		reloadBsUrl(pkg, url);
	} else {
		print("Ignoring non BS-file: " # url);
	}
}

void reloadBsUrl(Package pkg, Url url) on Compiler {
	Str text = url.read.readText.readAll;
	Scope scope(pkg, BSLookup());

	Parser<SIncludes> header;
	header.addSyntax(pkg);
	header.parse(text, url);
	if (!header.hasTree)
		header.throwError;
	var headerEnd = header.matchEnd;

	addIncludes(scope, header.tree.transform);

	Parser<SFile> body;
	scope.addSyntax(body);
	body.parse(text, url, headerEnd);
	if (body.hasError)
		body.throwError;

	reloadContents(pkg, scope, body.tree.transform(scope));
}

void reloadContents(Package pkg, Scope scope, Content c) on Compiler {
	reloadTypes(pkg, scope, c);
	reloadDecls(pkg, scope, c);
}

void reloadDecls(Package pkg, Scope scope, Content c) on Compiler {
	for (Nat i = 0; i < c.decls.count; i++) {
		NamedDecl decl = c.decls[i];
		if (new = decl.update(scope)) {
			print("New function: " # new.name);
			pkg.add(new);
		}
	}
}

void reloadTypes(Package pkg, Scope scope, Content c) on Compiler {
	for (Nat i = 0; i < c.types.count; i++) {
		Type t = c.types[i];
		if (t as Class) {
			Named? found = scope.find(Name(t.name));
			if (found as Class) {
				// We need lookups to work... Hack...
				t.parentLookup = pkg;
				reloadClass(found, t);
			} else if (found.empty) {
				print("New type: " # t.name);
				pkg.add(t);
			} else {
				print("Could not update " # t.name # ", the previous function was not found,"
					# " or not declared in Basic Storm.");
			}
		} else {
			print(t # " is not a Class from Basic Storm, can not replace it.");
		}
	}
}

void reloadClass(Class found, Type candidate) on Compiler {
	Scope scope(found);
	Named[] members = candidate.content;
	for (Nat i = 0; i < members.count; i++) {
		Named member = members[i];
		if (member as BSFunction) {
			// Replace the this ptr.
			Value[] params = member.params;
			params[0] = Value(found, params[0].ref);

			SimplePart name(member.name, params);
			Named? replace = scope.find(Name(name));
			if (replace as BSFunction) {
				replace.update(member);
			} else if (replace.empty) {
				print(name # " not found.");
			} else {
				print("Ignoring " # replace # ", not declared in Basic Storm.");
			}
		} else if (member as BSCtor) {
			// print("Ignoring constructor " # member # ", constructors not supported yet.");
		}
	}
}

// Why can't I use SrcName[] here?
void addIncludes(Scope scope, Array<SrcName> from) on Compiler {
	for (Nat i = 0; i < from.count; i++) {
		Named? p = rootScope.find(from[i]);
		if (p as Package) {
			scope.addInclude(p);
		} else {
			print("Failed to include " # from[i]);
		}
	}
}

