Getting Help
============

The top loop provides easy access to the documentation that is built into Storm through the `help`
command.  For example, to get help about the `layout` package one can type: `help layout` The system
then responds roughly as follows:

```
layout (package):

Layout Library
==============

This is a library for specifying the layout of a set of rectangles inside a
container (for example, UI components on the screen). The library itself is
generic and requires a small amount of code to integrate it in whichever context
it should be used.

The library is centered around the `Component` class, which represents a
rectangle that should be positioned. Components are positioned inside a
`Layout`, that is in charge of determining the relative position of each
component. Each `Layout` is also a `Component`, which means that layout rules
can be nested to create arbitrarily complex layouts.

The layout system does not introduce additional coordinate systems. Rather, all
coordinates produced are in the same coordinate system as those specified to the
`Layout` that contains the `Component`s.


At: <unknown location>

Members:
 @ 0 extends lang.bs.SAtom, on core.Compiler
 @ 1 extends layout.SLayoutRoot, on core.Compiler
...
 Anchor extends layout.Layout [public]
 Border extends layout.Layout [public]
 Cardinal extends core.Object [public]
 Component extends core.Object [public]
...
```

The first line specifies what the name refers to. In this case it is a package, which is represented
by the package name followed by `(package)`. After that line, the documentation for the entity is
printed if it exists. After the documentation, the source location is printed. Since packages are
not defined in a particular file, the system prints `<unknown location>` to indicate this. Finally,
all members in the package are printed. The first few (starting with `@`) are anonymous types
generated by the syntax language. After them are a few classes.

If we are interested in more information about the class `Component`, we can then type: `help
layout:Component`, which results in output similar to the following:

```
public Component extends core.Object:

Describes a component in the layout hierarchy.

A component is a rectangle that will be laid out according to the rules of the
active Layout. The Component class also stores information about the underlying
component, such as minimum size and other component-specific information.

Provide a function called `component` to wrap custom types inside the
`Component` class. The system will try to call that function automatically when
possible.

Generally, all information inside a particular component is assumed to be read-only.

At: /.../root/layout/component.bs(583-1413)

Members:
 __init(layout.Component) -> void
 __init(layout.Component, layout.Component) -> void
 bundleRoot(layout.Component) -> core.Maybe(layout.Component) [public]
 deepCopy(layout.Component, core.CloneEnv) -> void
 findAll(layout.Component, core.Fn(void, layout.Component)) -> void [public]
 minSize(layout.Component) -> core.geometry.Size [public]
 pos(layout.Component) -> core.geometry.Rect [public]
 pos(layout.Component, core.geometry.Rect) -> void, assign [public]
 toAdd(layout.Component) -> layout.Component [public]
```

This time, the name `layout:Component` refers to a class, which is printed using a format similar to
the class definition (`public Component extends core.Object`). Again, after the description of what
the name refers to is the documentation of the entity is shown, and the location in the source code.
The numbers after the file name indicates the range of characters in the file where the entity is
defined. Finally, a list of members are listed. The lines `__init` indicate constructors.

Finally, assume we wish to read the documentation for the `pos` member. The full name of this entity
is `layout:Component:pos(layout:Component)` or `layout:Component:pos(layout:Component,
core:geometry:Rect)`. It is possible to type these names as parameters to `help`. Since that would
be cumbersome to do, the help syntax allows omitting parameter lists. So, typing `help
layout:Component:pos` is enough, and produces the following output:

```
Found 2 overloads for pos:

public pos(layout.Component this) -> core.geometry.Rect:

Get the position of this component.

At: /home/filip/Projects/storm/root/layout/component.bs(1135-1138)

public pos(layout.Component this, core.geometry.Rect p) -> void, assign:

Set the position of this component.

At: /home/filip/Projects/storm/root/layout/component.bs(1205-1208)
```

The first line states that the system found two overloads of `pos` in the package. It then proceeds
to display both of them. In this case, we can see that the first function takes a parameter called
`this` (since it is a member function) and returns a `core:geometry:Rect`. The second version
accepts another parameter (`p`) and returns `void`. Furthermore, the second function is marked as
`assign`, which tells the system that the member may be used when assigning to the `pos` member.
