/* ====================================================================
 * Copyright (c) 2009       Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SINGLEPROJECTREADER_TEST_H
#define _SINGLEPROJECTREADER_TEST_H

// cppunit
#include <cppunit/TestFixture.h>
#include <cppunit/extensions/HelperMacros.h>

// sc
class SingleProjectReader;


class SingleProjectReaderTest : public CppUnit::TestCase 
{
  CPPUNIT_TEST_SUITE( SingleProjectReaderTest );
  CPPUNIT_TEST( testProjectRoot );
  CPPUNIT_TEST( testTrunkItem );
  CPPUNIT_TEST( testBranchesItem );
  CPPUNIT_TEST( testTagsItem );
  CPPUNIT_TEST( testWcItem0 );
  CPPUNIT_TEST( testWcItem1 );
  CPPUNIT_TEST( testSubItemOfWcItem0 );
  CPPUNIT_TEST( testSubItemOfWcItem1 );
  CPPUNIT_TEST( testRpItem0 );
  CPPUNIT_TEST( testRpItem1 );
  CPPUNIT_TEST_SUITE_END(); 

public:
  void setUp();
  void tearDown();

  // Tests
  void testProjectRoot();
  void testTrunkItem();
  void testBranchesItem();
  void testTagsItem();
  void testWcItem0();
  void testWcItem1();
  void testSubItemOfWcItem0();
  void testSubItemOfWcItem1();
  void testRpItem0();
  void testRpItem1();

private:
  SingleProjectReader* _reader;
};

#endif // _SINGLEPROJECTREADER_TEST_H
