// Copyright (C) 2006-2009 Kent-Andre Mardal and Simula Research Laboratory
//
// This file is part of SyFi.
//
// SyFi is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 2 of the License, or
// (at your option) any later version.
//
// SyFi is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with SyFi. If not, see <http://www.gnu.org/licenses/>.

#include "DiscontinuousLagrange.h"
#include "ElementComputations.h"

using std::cout;
using std::endl;

namespace SyFi
{

	DiscontinuousLagrange:: DiscontinuousLagrange(Polygon& p, unsigned int order) : Lagrange(p,order)
	{
		compute_basis_functions();
		element = GiNaC::symbol("e");
	}

	DiscontinuousLagrange:: DiscontinuousLagrange() : Lagrange()
	{
		description = "DiscontinuousLagrange";
		element = GiNaC::symbol("e");
	}

	void DiscontinuousLagrange:: compute_basis_functions()
	{

		// remove previously computed basis functions and dofs
		Ns.clear();
		dofs.clear();

		if ( order < 1 )
		{
			throw(std::logic_error("Discontinuous Lagrangian elements must be of order 1 or higher."));
		}

		if ( p == NULL )
		{
			throw(std::logic_error("You need to set a polygon before the basisfunctions can be computed"));
		}

		//FIXME should have element defined somehow other than
		//setting it to zero
		//
		//It could be a symbol 'e' instead ?

		Lagrange:: compute_basis_functions();
		for (unsigned int i=0; i< dofs.size(); i++)
		{
			dofs[i] = GiNaC::lst(dofs[i], element);
		}

		description = "Discontinuous" +  Lagrange:: str();
	}

	void DiscontinuousLagrange:: set_element_number(unsigned int element_)
	{
		element = element_;
	}

	// ------------VectorDiscontinuousLagrange ---

	VectorDiscontinuousLagrange:: VectorDiscontinuousLagrange(Polygon& p, unsigned int order) : VectorLagrange(p,order)
	{
		compute_basis_functions();
		element = GiNaC::symbol("e");
	}

	VectorDiscontinuousLagrange:: VectorDiscontinuousLagrange() :
	VectorLagrange()
	{
		description = "DiscontinuousLagrange";
		element = GiNaC::symbol("e");
	}

	void VectorDiscontinuousLagrange:: compute_basis_functions()
	{

		// remove previously computed basis functions and dofs
		Ns.clear();
		dofs.clear();

		VectorLagrange:: compute_basis_functions();

		for (unsigned int i=0; i< dofs.size(); i++)
		{
			dofs[i] = GiNaC::lst(dofs[i].op(0), dofs[i].op(1), element);
		}

		description = "Discontinuous" +  VectorLagrange:: str();
	}

	void VectorDiscontinuousLagrange:: set_size(unsigned int size_)
	{
		VectorLagrange::set_size(size_);
	}

	void VectorDiscontinuousLagrange:: set_element_number(unsigned int element_)
	{
		element = element_;
	}

}								 // namespace SyFi
