C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C/MEMBR ADD NAME=OV,SSI=0
C
                     SUBROUTINE OV
C                    *************
C
C     -----------------------
     *( OP,X,Y,Z,C,NPOINS )
C     -----------------------  
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C                                                                      *
C      FONCTION :                                                      *
C      ---------     OPERATIONS SUR LES VECTEURS                       *
C                                                                      *
C                    OP est une chaine de 8 caracteres qui indique     *
C                    l'ordre des operations effectuee sur les vecteurs *
C                    X,Y,Z et la constante C. Le resultat est dans le  *
C                    vecteur X.                                        *
C                                                                      *
C      OP = 'X=C     '      : X mis a la valeur C                      *
C      OP = 'X=Y     '      : Y copie dans X                           *
C      OP = 'X=1/Y   '      : Inverse de Y mis dans X                  *
C      OP = 'X=1/X   '      : Inverse de X mis dans X                  *
C      OP = '                                                          *
C                                                                      *
C-----------------------------------------------------------------------
C		    (*)    (*)			ARGUMENTS
C   .___________.______._______________________________________________.
C   !    NOM    ! TYPE !MODE!                    ROLE                  !
C   !___________!______!____!__________________________________________!
C   !   OP      !  A   ! D  ! DEFINITION DU TYPE D'OPERATION           !
C   !   X       !  TR  ! M  ! VECTEUR RESULTAT                         !
C   !   Y       !  TR  ! D  ! VECTEUR OPERANDE                         !
C   !   Y       !  TR  ! D  ! VECTEUR OPERANDE                         !
C   !   C       !  R   ! D  ! CONSTANTE                                !
C   !   NPOINS  !  E   ! D  ! NOMBRE DE POINTS DES VECTEURS            !
C   !___________!______!____!__________________________________________!
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C    SOUS PROGRAMME(S) APPELE(S)    : ????
C                                     ????
C-----------------------------------------------------------------------
C    SOUS PROGRAMME(S) APPELANT(S)  : ????
C
C***********************************************************************
C
	IMPLICIT NONE
C
C***********************************************************************
C	DONNEES EN COMMON
C***********************************************************************
C
#include "nlofes.h"
C
C***********************************************************************
      INTEGER NPOINS
C
      DOUBLE PRECISION X(NPOINS),Y(NPOINS),Z(NPOINS)
      DOUBLE PRECISION C
      CHARACTER*8 OP
C
C     variables internes
      INTEGER I
      DOUBLE PRECISION EPSMAC
C      
C***********************************************************************
C     
C     INITIALISATIONS
C     ===============
C         
      EPSMAC = 1.D-30
C
C     CALCUL SUR LES VECTEURS
C     =======================
C   
      IF ( OP(1:8).EQ.'X=C     ') THEN
          DO 10 I=1,NPOINS
              X(I) = C
   10     CONTINUE
C
C     ------------------------------------------------------------------
C
      ELSEIF ( OP(1:8).EQ.'X=Y     ') THEN
          DO 20 I=1,NPOINS
              X(I) = Y(I)
   20     CONTINUE
C
C     ------------------------------------------------------------------
C     Il faut tester si y n'est pas nul (a faire)
C
      ELSEIF ( OP(1:8).EQ.'X=1/Y   ') THEN
          DO 30 I=1,NPOINS
              IF (ABS(Y(I)) .GT. EPSMAC) THEN
                 X(I) = 1.D0 / Y(I)
              ELSE
                 WRITE(NFECRA,*) 
     *          'probleme de division par zero dans ov N=',i,' Y=',Y(I)
              ENDIF
   30     CONTINUE       
C
C     ------------------------------------------------------------------
C     Il faut tester si x n'est pas nul (a faire)
C
      ELSEIF ( OP(1:8).EQ.'X=1/X   ') THEN
          DO 40 I=1,NPOINS
              IF (ABS(X(I)) .GT. EPSMAC) THEN
                 X(I) = 1.D0 / X(I)
              ELSE
                 WRITE(NFECRA,*) 
     *          'probleme de division par zero dans ov N=',i,' X=',X(I)
              ENDIF
   40     CONTINUE
C
C     ------------------------------------------------------------------
C
      ELSEIF ( OP(1:8).EQ.'X=Y+Z   ') THEN
          DO 50 I=1,NPOINS
              X(I) = Y(I) + Z(I)
   50     CONTINUE
C
C     ------------------------------------------------------------------
C
      ELSEIF ( OP(1:8).EQ.'X=Y-Z   ') THEN
          DO 60 I=1,NPOINS
              X(I) = Y(I) - Z(I)
   60     CONTINUE
C
C     ------------------------------------------------------------------
C
      ELSEIF ( OP(1:8).EQ.'X=YZ    ') THEN
          DO 70 I=1,NPOINS
              X(I) = Y(I) * Z(I)
   70     CONTINUE   
C
C     ------------------------------------------------------------------
C
      ELSEIF ( OP(1:8).EQ.'X=XY    ') THEN
          DO 80 I=1,NPOINS
              X(I) = X(I) * Y(I)
   80     CONTINUE
C
C     ------------------------------------------------------------------
C
      ELSEIF ( OP(1:8).EQ.'X=X+YZ  ') THEN
          DO 90 I=1,NPOINS
              X(I) = X(I) + Y(I) * Z(I)
   90     CONTINUE
C
C     ------------------------------------------------------------------
C
      ELSEIF ( OP(1:8).EQ.'X=X-YZ  ') THEN
          DO 100 I=1,NPOINS
              X(I) = Y(I) * Z(I)
  100     CONTINUE  
C
C     ------------------------------------------------------------------
C
      ELSEIF ( OP(1:8).EQ.'X=XY    ') THEN
          DO 110 I=1,NPOINS
              X(I) = X(I) * Y(I)
  110     CONTINUE
C
C     ------------------------------------------------------------------
C
      ELSEIF ( OP(1:8).EQ.'X=X-YZ  ') THEN
          DO 120 I=1,NPOINS
              X(I) = X(I) - Y(I) * Z(I)
  120     CONTINUE 
C
C     ------------------------------------------------------------------
C
      ELSEIF ( OP(1:8).EQ.'X=X+CYZ  ') THEN
          DO 130 I=1,NPOINS
              X(I) = X(I) + C * Y(I) * Z(I)
  130     CONTINUE 
C
C     ------------------------------------------------------------------
C
      ELSEIF ( OP(1:8).EQ.'X=Y/Z   ') THEN
          DO 140 I=1,NPOINS
              IF (ABS(Z(I)) .GT. EPSMAC) THEN
                 X(I) = Y(I) / Z(I)
              ELSE
                 WRITE(NFECRA,*) 'probleme de division par zero dans ov'
                 STOP
              ENDIF
  140     CONTINUE  
C
C     ------------------------------------------------------------------
C
      ELSEIF ( OP(1:8).EQ.'X=X+Y    ') THEN
          DO 150 I=1,NPOINS
              X(I) = X(I) + Y(I)
  150     CONTINUE
C
C     ------------------------------------------------------------------
C
      ELSEIF ( OP(1:8).EQ.'X=X-Y   ') THEN
          DO 160 I=1,NPOINS
              X(I) = X(I) - Y(I)
  160     CONTINUE
C
C     ------------------------------------------------------------------
C
      ELSEIF ( OP(1:8).EQ.'X=CX    ') THEN
          DO 170 I=1,NPOINS
              X(I) = C * X(I)
  170     CONTINUE 
C
C     ------------------------------------------------------------------
C
      ELSEIF ( OP(1:8).EQ.'X=CY    ') THEN
          DO 180 I=1,NPOINS
              X(I) = C * Y(I)
  180     CONTINUE
C
C     ------------------------------------------------------------------
C
      ELSEIF ( OP(1:8).EQ.'X=X+CY  ') THEN
          DO 190 I=1,NPOINS
              X(I) = X(I) + C * Y(I)
  190     CONTINUE
C
C     ------------------------------------------------------------------
C
      ELSEIF ( OP(1:8).EQ.'X=SQR(Y)') THEN
          DO 200 I=1,NPOINS
              X(I) = SQRT( Y(I) )
  200     CONTINUE 
C
C     ------------------------------------------------------------------
C
      ELSEIF ( OP(1:8).EQ.'X=Y+CZ') THEN
          DO 210 I=1,NPOINS
              X(I) = Y(I) + C * Z(I)
  210     CONTINUE 
C
C     ------------------------------------------------------------------
C
      ELSE
          WRITE ( NFECRA,1000 ) OP
          STOP
      ENDIF
C
C************************************************************************
C     FORMATS
C------------------------------------------------------------------------
C
 1000 FORMAT( / ,' %% ERREUR OV : OPERATION INCONNUE ', A8 )
C
      RETURN
      END 
                                                       
