from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


aliases = _Mock()

app_aliases = _Mock()

app_flags = _Mock()

atexit = _Mock()

boolean_flag = _Mock()

classes = _Mock()

default_secure = _Mock()

filefind = _Mock()

find_connection_file = _Mock()

flags = _Mock()

json = _Mock()

kernel_aliases = _Mock()

kernel_flags = _Mock()

localhost = _Mock()

os = _Mock()

signal = _Mock()

str_to_bytes = _Mock()

swallow_argv = _Mock()

sys = _Mock()

tunnel_to_kernel = _Mock()

uuid = _Mock()



class Any(_Mock):
  pass
  info_text = 'any value'

class BlockingKernelClient(_Mock):
  pass


class CBool(_Mock):
  pass
  default_value = False
  info_text = 'a boolean'

class CUnicode(_Mock):
  pass
  default_value = u''
  info_text = 'a unicode string'

class ConnectionFileMixin(_Mock):
  pass


class Dict(_Mock):
  pass
  info_text = 'any value'

class IPKernelApp(_Mock):
  pass
  _in_init_profile_dir = False
  name = 'ipkernel'

class IPythonConsoleApp(_Mock):
  pass
  description = '\n        The IPython Mixin Console.\n        \n        This class contains the common portions of console client (QtConsole,\n        ZMQ-based terminal console, etc).  It is not a full console, in that\n        launched terminal subprocesses will not be able to accept input.\n        \n        The Console using this mixing supports various extra features beyond\n        the single-process Terminal IPython shell, such as connecting to\n        existing kernel, via:\n        \n            ipython <appname> --existing\n        \n        as well as tunnel via SSH\n        \n    '
  name = 'ipython-console-mixin'

class InlineBackend(_Mock):
  pass


class Int(_Mock):
  pass
  default_value = 0
  info_text = 'an int'

class KernelManager(_Mock):
  pass


class List(_Mock):
  pass
  info_text = 'any value'

class ProfileDir(_Mock):
  pass


class Session(_Mock):
  pass


class Unicode(_Mock):
  pass
  default_value = u''
  info_text = 'a unicode string'

class ZMQInteractiveShell(_Mock):
  pass
  default_user_namespaces = True

